/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material;

import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.material.ResourceRegistry;
import com.hrznstudio.titanium.material.ResourceTypeProperties;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ResourceMaterial {
    private String type;
    private HashMap<String, IResourceType> generatorTypes;
    private HashMap<String, ForgeRegistryEntry> generatorOverrides;
    private HashMap<String, ForgeRegistryEntry> generated;
    private HashMap<String, ResourceTypeProperties> typeProperties;
    private int color;

    ResourceMaterial(String type) {
        this.type = type;
        this.generatorTypes = new HashMap();
        this.generatorOverrides = new HashMap();
        this.generated = new HashMap();
        this.typeProperties = new HashMap();
    }

    public String getMaterialType() {
        return this.type;
    }

    public ResourceMaterial add(IResourceType type) {
        this.generatorTypes.computeIfAbsent(type.getTag(), s -> type);
        return this;
    }

    public ResourceMaterial addAll(IResourceType ... type) {
        for (IResourceType iResourceType : type) {
            this.add(iResourceType);
        }
        return this;
    }

    public ResourceMaterial withOverride(IResourceType type, ForgeRegistryEntry entry) {
        this.generatorOverrides.put(type.getTag(), entry);
        return this;
    }

    public ResourceMaterial withProperties(IResourceType type, ResourceTypeProperties properties) {
        this.typeProperties.computeIfAbsent(type.func_176610_l(), s -> properties);
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public ResourceMaterial setColor(int color) {
        this.color = color;
        return this;
    }

    public Map<String, IResourceType> getGeneratorTypes() {
        return this.generatorTypes;
    }

    public Map<String, ForgeRegistryEntry> getGeneratorOverrides() {
        return this.generatorOverrides;
    }

    public Map<String, ForgeRegistryEntry> getGenerated() {
        return this.generated;
    }

    @Nullable
    public ForgeRegistryEntry generate(IResourceType type) {
        if (this.generatorOverrides.containsKey(type.getTag())) {
            ForgeRegistryEntry entry = this.generatorOverrides.get(type.getTag());
            this.generated.put(type.getTag(), entry);
            ResourceRegistry.injectField(this, type, entry);
            return null;
        }
        ForgeRegistryEntry entry = type.getInstanceFactory(this, this.typeProperties.get(type.func_176610_l())).create();
        this.generated.put(type.getTag(), entry);
        ResourceRegistry.injectField(this, type, entry);
        return entry;
    }

    public ITextComponent getTextComponent() {
        return new TranslationTextComponent(String.format("resource.titanium.material.%s", this.type), new Object[0]);
    }
}

