/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.capabilities.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;
import net.ndrei.teslacorelib.capabilities.inventory.ISidedItemHandlerConfig;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandlerInfo;

public class SidedItemHandlerConfig
implements ISidedItemHandlerConfig,
INBTSerializable<NBTTagList> {
    private Map<EnumDyeColor, List<EnumFacing>> facesConfig = new HashMap<EnumDyeColor, List<EnumFacing>>();
    private List<ColoredItemHandlerInfo> information;

    @Override
    public boolean isSideSet(EnumDyeColor color, EnumFacing side) {
        List<EnumFacing> list;
        if (this.facesConfig.containsKey(color) && (list = this.facesConfig.get(color)) != null && list.contains(side)) {
            for (EnumFacing facing : list) {
                if (facing != side) continue;
                return true;
            }
        }
        return false;
    }

    public boolean toggleSide(EnumDyeColor color, EnumFacing side) {
        if (this.facesConfig.containsKey(color)) {
            List<EnumFacing> list = this.facesConfig.get(color);
            if (list != null && list.contains(side)) {
                list.remove(side);
            } else if (list != null) {
                list.add(side);
            } else {
                this.setSidesForColor(color, Lists.newArrayList((Object[])new EnumFacing[]{side}));
            }
        } else {
            this.setSidesForColor(color, Lists.newArrayList((Object[])new EnumFacing[]{side}));
        }
        this.updated();
        return this.isSideSet(color, side);
    }

    @Override
    public List<ColoredItemHandlerInfo> getColoredInfo() {
        return this.information == null ? Lists.newArrayList() : this.information;
    }

    @Override
    public void addColoredInfo(String name, EnumDyeColor color, BoundingRectangle highlight) {
        this.addColoredInfo(new ColoredItemHandlerInfo(name, color, highlight));
    }

    @Override
    public void addColoredInfo(ColoredItemHandlerInfo info) {
        if (this.information == null) {
            this.information = Lists.newArrayList();
        }
        this.information.add(info);
    }

    @Override
    public List<EnumFacing> getSidesForColor(EnumDyeColor color) {
        List<Object> list = this.facesConfig.containsKey(color) ? this.facesConfig.get(color) : Lists.newArrayList();
        return list;
    }

    @Override
    public void setSidesForColor(EnumDyeColor color, List<EnumFacing> sides) {
        if (sides == null) {
            sides = Lists.newArrayList();
        }
        this.facesConfig.put(color, sides);
        this.updated();
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        EnumDyeColor[] keys = this.facesConfig.keySet().toArray(new EnumDyeColor[0]);
        for (int k = 0; k < keys.length; ++k) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("color", keys[k].func_176765_a());
            NBTTagList sides = new NBTTagList();
            for (EnumFacing facing : this.facesConfig.get(keys[k])) {
                sides.func_74742_a((NBTBase)new NBTTagInt(facing.func_176745_a()));
            }
            nbt.func_74782_a("sides", (NBTBase)sides);
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    public void deserializeNBT(NBTTagList nbt) {
        this.facesConfig.clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound item = nbt.func_150305_b(i);
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)item.func_74762_e("color"));
            ArrayList sides = Lists.newArrayList();
            NBTTagList list = item.func_150295_c("sides", 3);
            for (int j = 0; j < list.func_74745_c(); ++j) {
                sides.add(EnumFacing.func_82600_a((int)list.func_186858_c(j)));
            }
            this.facesConfig.put(color, sides);
        }
        this.updated();
    }

    protected void updated() {
    }

    @Override
    public void removeColoredInfo(EnumDyeColor color) {
        this.information.removeIf(i -> i.getColor() == color);
        this.facesConfig.remove(color);
        this.updated();
    }
}

