/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.containers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BasicTeslaContainer<T extends SidedTileEntity>
extends Container {
    private T entity;
    private int entitySlots = 0;
    private int playerSlots = 0;
    private int playerExtraSlots = 0;
    private int playerQuickSlots = 0;
    private EntityPlayer player;
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public BasicTeslaContainer(T entity, EntityPlayer player) {
        this.entity = entity;
        this.player = player;
        List<Slot> slots = ((SidedTileEntity)this.entity).getSlots(this);
        if (slots != null) {
            this.entitySlots = slots.size();
            for (Slot slot : slots) {
                this.func_75146_a(slot);
            }
        }
        if (player != null) {
            this.playerExtraSlots = this.addPlayerExtraSlots(player);
            this.playerQuickSlots = this.addPlayerQuickBar(player);
            this.playerSlots = this.addPlayerInventory(player);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return !this.entity.func_145837_r() && playerIn.func_174818_b(this.entity.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    protected int addPlayerQuickBar(EntityPlayer player) {
        if (player == null) {
            return 0;
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 160));
        }
        return 9;
    }

    protected int addPlayerInventory(EntityPlayer player) {
        if (player == null) {
            return 0;
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + (y + 1) * 9, 8 + x * 18, 102 + y * 18));
            }
        }
        return 27;
    }

    protected int addPlayerExtraSlots(final EntityPlayer player) {
        if (player == null) {
            return 0;
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a(new Slot((IInventory)playerInventory, 36 + (3 - k), 174, 84 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (ItemStackUtil.isEmpty(itemstack) || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        this.func_75146_a(new Slot((IInventory)playerInventory, 40, 174, 160){

            @Nullable
            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        return 5;
    }

    public boolean hasPlayerInventory() {
        return this.playerSlots > 0;
    }

    public void hidePlayerInventory() {
        while (this.playerSlots > 0) {
            this.field_75151_b.remove(this.field_75151_b.size() - 1);
            --this.playerSlots;
        }
    }

    public void showPlayerInventory() {
        if (this.playerSlots == 0 && this.player != null) {
            this.playerSlots = this.addPlayerInventory(this.player);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack copyStack = ItemStackUtil.getEmptyStack();
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            copyStack = origStack.func_77946_l();
            boolean merged = false;
            for (SlotRange range : this.getSlotsRange(index)) {
                if (!super.func_75135_a(origStack, range.start, range.end, range.reverse)) continue;
                merged = true;
                break;
            }
            if (!merged) {
                return ItemStackUtil.getEmptyStack();
            }
        }
        return copyStack;
    }

    private List<SlotRange> getSlotsRange(int sourceIndex) {
        int slots = this.field_75151_b.size();
        int playerSlots = this.playerSlots + this.playerQuickSlots + this.playerExtraSlots;
        int containerSlots = slots - playerSlots;
        ArrayList list = Lists.newArrayList();
        if (sourceIndex < containerSlots) {
            if (this.playerSlots > 0) {
                list.add(new SlotRange(slots - this.playerSlots, slots, false));
            }
            list.add(new SlotRange(containerSlots, containerSlots + this.playerExtraSlots - 1, false));
            list.add(new SlotRange(containerSlots + this.playerExtraSlots, containerSlots + this.playerExtraSlots + this.playerQuickSlots, true));
            list.add(new SlotRange(containerSlots + this.playerExtraSlots - 1, containerSlots + this.playerExtraSlots, false));
        } else {
            list.add(new SlotRange(0, containerSlots, false));
        }
        return list;
    }

    private final class SlotRange {
        public final int start;
        public final int end;
        public final boolean reverse;

        public SlotRange(int start, int end, boolean reverse) {
            this.start = start;
            this.end = end;
            this.reverse = reverse;
        }
    }
}

