/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.ndrei.teslacorelib.compatibility.FontRendererUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BasicTeslaGuiContainer<T extends SidedTileEntity>
extends GuiContainer {
    public static final ResourceLocation MACHINE_BACKGROUND = new ResourceLocation("teslacorelib", "textures/gui/basic-machine.png");
    private T entity;
    private List<IGuiContainerPiece> pieces;
    private int guiId;

    public BasicTeslaGuiContainer(int id, Container container, T entity) {
        super(container);
        this.guiId = id;
        this.entity = entity;
        this.field_146999_f = 198;
        this.field_147000_g = 184;
        this.refreshParts();
    }

    public BasicTeslaContainer getTeslaContainer() {
        if (this.field_147002_h instanceof BasicTeslaContainer) {
            return (BasicTeslaContainer)this.field_147002_h;
        }
        return null;
    }

    public int getGuiId() {
        return this.guiId;
    }

    public T getEntity() {
        return this.entity;
    }

    protected void bindDefaultTexture() {
        BasicTeslaGuiContainer.bindDefaultTexture(this);
    }

    public static void bindDefaultTexture(GuiContainer container) {
        container.field_146297_k.func_110434_K().func_110577_a(MACHINE_BACKGROUND);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.bindDefaultTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, super.getXSize(), super.getYSize());
        for (IGuiContainerPiece piece : this.pieces) {
            if (!piece.isVisible()) continue;
            piece.drawBackgroundLayer(this, this.field_147003_i, this.field_147009_r, partialTicks, mouseX, mouseY);
        }
        for (IGuiContainerPiece piece : this.pieces) {
            if (!piece.isVisible()) continue;
            piece.drawMiddleLayer(this, this.field_147003_i, this.field_147009_r, partialTicks, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (IGuiContainerPiece piece : this.pieces) {
            if (!piece.isVisible()) continue;
            piece.drawForegroundLayer(this, this.field_147003_i, this.field_147009_r, mouseX, mouseY);
        }
        for (IGuiContainerPiece piece : this.pieces) {
            if (!piece.isVisible()) continue;
            piece.drawForegroundTopLayer(this, this.field_147003_i, this.field_147009_r, mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IGuiContainerPiece piece : this.pieces) {
            if (!piece.isVisible() || !BasicContainerGuiPiece.isInside(this, piece, mouseX, mouseY)) continue;
            piece.mouseClicked(this, mouseX, mouseY, mouseButton);
        }
    }

    public void drawTexturedRect(int x, int y, int textureX, int textureY, int width, int height) {
        super.func_73729_b(this.field_147003_i + x, this.field_147009_r + y, textureX, textureY, width, height);
    }

    public void drawTooltip(List<String> textLines, int x, int y) {
        super.func_146283_a(textLines, x, y);
    }

    public void drawFilledRect(int x, int y, int width, int height, int color) {
        super.func_73733_a(x, y, x + width, y + height, color, color);
    }

    public void drawFilledRect(int x, int y, int width, int height, int color, int strokeColor) {
        this.drawFilledRect(x, y, width, height, color);
        super.func_73730_a(x, x + width - 1, y, strokeColor);
        super.func_73728_b(x, y, y + height - 1, strokeColor);
        super.func_73728_b(x + width - 1, y, y + height - 1, strokeColor);
        super.func_73730_a(x, x + width - 1, y + height - 1, strokeColor);
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public FontRenderer getFontRenderer() {
        return FontRendererUtil.getFontRenderer();
    }

    public void setZIndex(float zLevel) {
        this.field_73735_i = zLevel;
    }

    private void refreshParts() {
        ArrayList pieces = ((SidedTileEntity)this.entity).getGuiContainerPieces(this);
        this.pieces = pieces != null ? pieces : Lists.newArrayList();
    }

    public static void refreshParts(World world) {
        if (world != null && world.field_72995_K && Minecraft.func_71410_x().field_71462_r instanceof BasicTeslaGuiContainer) {
            ((BasicTeslaGuiContainer)Minecraft.func_71410_x().field_71462_r).refreshParts();
        }
    }
}

