/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.energy.IStrictEnergyAcceptor;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.ndrei.teslacorelib.capabilities.inventory.ISidedItemHandlerConfig;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.IEnergyStatistics;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyAcceptor", modid="Mekanism")})
public class EnergyStorage
implements ITeslaConsumer,
ITeslaHolder,
ITeslaProducer,
IStrictEnergyAcceptor,
IEnergyStorage,
INBTSerializable<NBTTagCompound>,
ICapabilityProvider,
IEnergyStatistics {
    private long stored = 0L;
    private long capacity = 0L;
    private long inputRate;
    private long outputRate;
    private EnumDyeColor color;
    private ISidedItemHandlerConfig sidedConfig = null;
    private long statStored = 0L;
    private long statAverage = 0L;
    private long statTick = 0L;
    private List<Long> statTicks = Lists.newArrayList();

    public EnergyStorage(long maxStoredEnergy, long inputRate, long outputRate) {
        this.color = this.color;
        this.capacity = maxStoredEnergy;
        this.inputRate = Math.max(0L, inputRate);
        this.outputRate = Math.max(0L, outputRate);
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public long workPerformed(long jobEnergy) {
        return this.workPerformed(jobEnergy, 1.0f);
    }

    public long workPerformed(long jobEnergy, float jobPercent) {
        long energy = Math.round((double)jobEnergy * (double)Math.max(0.0f, Math.min(1.0f, jobPercent)));
        return this.takePower(energy);
    }

    public long givePower(long energy) {
        return this.givePower(energy, false, true);
    }

    public long takePower(long energy) {
        return this.takePower(energy, false, true);
    }

    public boolean isFull() {
        return this.getCapacity() == this.getStoredPower();
    }

    public boolean isEmpty() {
        return this.getStoredPower() == 0L;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.givePower(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.takePower(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.getStoredPower());
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(Integer.MAX_VALUE, this.getCapacity());
    }

    public boolean canExtract() {
        return this.getOutputRate() > 0L;
    }

    public boolean canReceive() {
        return this.getInputRate() > 0L;
    }

    @Optional.Method(modid="Mekanism")
    public double getEnergy() {
        return this.getEnergyStored();
    }

    @Optional.Method(modid="Mekanism")
    public void setEnergy(double energy) {
    }

    @Optional.Method(modid="Mekanism")
    public double getMaxEnergy() {
        return this.getMaxEnergyStored();
    }

    @Optional.Method(modid="Mekanism")
    public double transferEnergyToAcceptor(EnumFacing side, double amount) {
        int tesla = Math.round((float)amount * 0.4f);
        tesla = this.receiveEnergy(tesla, false);
        return (double)tesla / 0.4;
    }

    @Optional.Method(modid="Mekanism")
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.canReceive();
    }

    public long getStoredPower() {
        return this.stored;
    }

    public long givePower(long tesla, boolean simulated) {
        return this.givePower(tesla, simulated, false);
    }

    private long givePower(long tesla, boolean simulated, boolean forced) {
        long acceptedTesla;
        long l = acceptedTesla = forced ? Math.min(this.getCapacity() - this.stored, tesla) : Math.min(this.getCapacity() - this.stored, Math.min(this.getInputRate(), tesla));
        if (!simulated) {
            this.stored += acceptedTesla;
            this.onChanged();
        }
        return acceptedTesla;
    }

    public long takePower(long tesla, boolean simulated) {
        return this.takePower(tesla, simulated, false);
    }

    private long takePower(long tesla, boolean simulated, boolean forced) {
        long removedPower;
        long l = removedPower = forced ? Math.min(this.stored, tesla) : Math.min(this.stored, Math.min(this.getOutputRate(), tesla));
        if (!simulated) {
            this.stored -= removedPower;
            this.onChanged();
        }
        return removedPower;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public EnergyStorage setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.stored > capacity) {
            this.stored = capacity;
        }
        this.onChanged();
        return this;
    }

    public long getInputRate() {
        return this.inputRate;
    }

    public EnergyStorage setInputRate(long rate) {
        this.inputRate = rate;
        return this;
    }

    public long getOutputRate() {
        return this.outputRate;
    }

    public EnergyStorage setOutputRate(long rate) {
        this.outputRate = rate;
        return this;
    }

    public EnergyStorage setTransferRate(long rate) {
        this.setInputRate(rate);
        this.setOutputRate(rate);
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74772_a("TeslaPower", this.stored);
        dataTag.func_74772_a("TeslaCapacity", this.capacity);
        dataTag.func_74772_a("TeslaInput", this.inputRate);
        dataTag.func_74772_a("TeslaOutput", this.outputRate);
        return dataTag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        long originalStored = this.stored;
        this.stored = nbt.func_74763_f("TeslaPower");
        if (nbt.func_74764_b("TeslaCapacity")) {
            this.capacity = nbt.func_74763_f("TeslaCapacity");
        }
        if (nbt.func_74764_b("TeslaInput")) {
            this.inputRate = nbt.func_74763_f("TeslaInput");
        }
        if (nbt.func_74764_b("TeslaOutput")) {
            this.outputRate = nbt.func_74763_f("TeslaOutput");
        }
        if (this.stored > this.getCapacity()) {
            this.stored = this.getCapacity();
        }
        if (this.stored != originalStored) {
            this.onChanged();
        }
    }

    public void onChanged() {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.sidedConfig != null && this.color != null && this.sidedConfig.isSideSet(this.color, facing)) {
            if (capability == CapabilityEnergy.ENERGY) {
                return true;
            }
            if (Loader.isModLoaded((String)"tesla") && this.hasTeslaCapability(capability)) {
                return true;
            }
            if (Loader.isModLoaded((String)"Mekanism") && Objects.equals(capability.getName(), "mekanism.api.energy.IStrictEnergyAcceptor")) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.sidedConfig != null && this.color != null && this.sidedConfig.isSideSet(this.color, facing)) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this;
            }
            if (Loader.isModLoaded((String)"tesla") && this.hasTeslaCapability(capability)) {
                return (T)this;
            }
            if (Loader.isModLoaded((String)"Mekanism") && Objects.equals(capability.getName(), "mekanism.api.energy.IStrictEnergyAcceptor")) {
                return (T)this;
            }
        }
        return null;
    }

    @Optional.Method(modid="tesla")
    private boolean hasTeslaCapability(Capability<?> capability) {
        if (capability == TeslaCapabilities.CAPABILITY_HOLDER) {
            return true;
        }
        if (this.getInputRate() > 0L && capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return true;
        }
        return this.getOutputRate() > 0L && capability == TeslaCapabilities.CAPABILITY_PRODUCER;
    }

    public void setSidedConfig(EnumDyeColor color, ISidedItemHandlerConfig sidedConfig, BoundingRectangle highlight) {
        if (this.sidedConfig == sidedConfig) {
            return;
        }
        this.sidedConfig = sidedConfig;
        this.color = color;
        if (this.sidedConfig != null) {
            this.sidedConfig.addColoredInfo("Energy", this.getColor(), highlight);
        }
    }

    public void processStatistics() {
        this.statTick = this.stored - this.statStored;
        this.statStored = this.stored;
        this.statTicks.add(this.statTick);
        while (this.statTicks.size() > 10) {
            this.statTicks.remove(0);
        }
        long sum = 0L;
        for (long l : this.statTicks) {
            sum += l;
        }
        this.statAverage = sum / (long)this.statTicks.size();
    }

    @Override
    public long getLastTickEnergy() {
        return this.statTick;
    }

    @Override
    public long getAverageEnergyPerTick() {
        return this.statAverage;
    }
}

