/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.inventory.IFilteredFluidTank;
import net.ndrei.teslacorelib.inventory.IFluidTankWrapper;

public class FilteredFluidTank
implements IFilteredFluidTank,
IFluidTankWrapper {
    private IFluidTank tank;
    private Fluid filter = null;

    public FilteredFluidTank(IFluidTank tank) {
        this(null, tank);
    }

    public FilteredFluidTank(Fluid filter, IFluidTank tank) {
        this.filter = filter;
        this.tank = tank;
    }

    @Override
    public boolean acceptsFluid(@Nonnull FluidStack fluid) {
        return this.filter == null || fluid.getFluid() == this.filter;
    }

    @Override
    public boolean canDrain() {
        return true;
    }

    @Override
    public boolean canFill() {
        return true;
    }

    @Nullable
    public FluidStack getFluid() {
        FluidStack stack = this.tank.getFluid();
        if (stack == null && this.filter != null) {
            stack = new FluidStack(this.filter, 0);
        }
        return stack;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.tank.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFill() || !this.acceptsFluid(resource)) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrain()) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public IFluidTank getInnerTank() {
        return this.tank;
    }
}

