/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredFluidHandler;
import net.ndrei.teslacorelib.inventory.FilteredFluidTank;
import net.ndrei.teslacorelib.inventory.FluidTank;
import net.ndrei.teslacorelib.inventory.IFilteredFluidTank;
import net.ndrei.teslacorelib.inventory.IFluidTankWrapper;
import net.ndrei.teslacorelib.inventory.ISerializableFluidTank;

public class FluidStorage
implements IFluidHandler,
INBTSerializable<NBTTagCompound> {
    private List<IFluidTank> tanks = Lists.newArrayList();

    public IFluidTankProperties[] getTankProperties() {
        ArrayList list = Lists.newArrayList();
        for (IFluidTank tank : this.tanks) {
            boolean canDrain = true;
            boolean canFill = true;
            if (tank instanceof IFilteredFluidTank) {
                IFilteredFluidTank filtered = (IFilteredFluidTank)tank;
                canDrain = filtered.canDrain();
                canFill = filtered.canFill();
            }
            list.add(new FluidTankProperties(tank.getFluid(), tank.getCapacity(), canFill, canDrain));
        }
        return list.toArray(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int used = 0;
        resource = resource.copy();
        for (IFluidTank tank : this.tanks) {
            IFilteredFluidTank filtered;
            if (tank instanceof IFilteredFluidTank && (!(filtered = (IFilteredFluidTank)tank).canFill() || !filtered.acceptsFluid(resource))) continue;
            int amount = tank.fill(resource, doFill);
            used += Math.min(amount, resource.amount);
            if (resource.amount <= amount) break;
            resource.amount -= amount;
        }
        return used;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(resource.amount, doDrain, resource);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain, null);
    }

    private FluidStack drain(int maxDrain, boolean doDrain, FluidStack filter) {
        FluidStack fluid;
        FluidStack fluidStack = fluid = filter == null ? null : filter.copy();
        if (fluid != null) {
            fluid.amount = 0;
        }
        for (IFluidTank tank : this.tanks) {
            FluidStack drained;
            FluidStack contained;
            IFilteredFluidTank filtered;
            if (tank instanceof IFilteredFluidTank && !(filtered = (IFilteredFluidTank)tank).canDrain() || (contained = tank.getFluid()) == null || filter != null && !contained.isFluidEqual(filter) || (drained = tank.drain(maxDrain, doDrain)) == null) continue;
            if (fluid == null) {
                fluid = drained.copy();
                if (filter != null) continue;
                filter = fluid;
                continue;
            }
            fluid.amount += drained.amount;
        }
        return fluid != null && fluid.amount == 0 ? null : fluid;
    }

    public IFluidTank[] getTanks() {
        return this.tanks.toArray(new IFluidTank[0]);
    }

    public void addTank(IFluidTank tank) {
        this.tanks.add(tank);
    }

    public FilteredFluidTank addTank(Fluid acceptedFluid, int capacity) {
        FilteredFluidTank tank = new FilteredFluidTank(acceptedFluid, new FluidTank(capacity));
        this.addTank(tank);
        return tank;
    }

    public ColoredFluidHandler addTank(Fluid acceptedFluid, IFluidTank tank, EnumDyeColor color, String name, BoundingRectangle boundingBox) {
        ColoredFluidHandler colored = new ColoredFluidHandler(acceptedFluid, tank, color, name, boundingBox);
        this.addTank(colored);
        return colored;
    }

    public void removeTank(IFluidTank tank) {
        this.tanks.removeIf(t -> FluidStorage.isSameTank(tank, t));
    }

    private static boolean isSameTank(IFluidTank a, IFluidTank b) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a != null && b != null && b instanceof IFluidTankWrapper) {
            return FluidStorage.isSameTank(a, ((IFluidTankWrapper)b).getInnerTank());
        }
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (IFluidTank tank : this.tanks) {
            NBTTagCompound tankNbt;
            if (tank instanceof FilteredFluidTank) {
                tank = ((FilteredFluidTank)tank).getInnerTank();
            }
            if (tank instanceof ISerializableFluidTank) {
                tankNbt = (NBTTagCompound)((ISerializableFluidTank)tank).serializeNBT();
            } else {
                tankNbt = new NBTTagCompound();
                FluidStack fluid = tank.getFluid();
                if (fluid != null) {
                    fluid.writeToNBT(tankNbt);
                } else {
                    tankNbt.func_74757_a("_empty", true);
                }
            }
            list.func_74742_a((NBTBase)tankNbt);
        }
        nbt.func_74782_a("tanks", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("tanks", 10);
        if (list != null) {
            for (int index = 0; index < list.func_74745_c() && index < this.tanks.size(); ++index) {
                int filled;
                IFluidTank tank = this.tanks.get(index);
                if (tank instanceof FilteredFluidTank) {
                    tank = ((FilteredFluidTank)tank).getInnerTank();
                }
                NBTTagCompound tankNbt = list.func_150305_b(index);
                if (tank instanceof ISerializableFluidTank) {
                    ((ISerializableFluidTank)tank).deserializeNBT((NBTBase)tankNbt);
                    continue;
                }
                FluidStack fluid = tankNbt.func_74764_b("_empty") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankNbt);
                if (tank.getFluidAmount() > 0) {
                    tank.drain(tank.getFluidAmount(), true);
                }
                if (fluid == null || (filled = tank.fill(fluid, true)) == fluid.amount) continue;
                TeslaCoreLib.logger.warn("FluidTank deserialized fluid wasn't totally put into tank: " + fluid.toString());
            }
        }
    }

    public int tankCount() {
        return this.tanks == null ? 0 : this.tanks.size();
    }

    public boolean acceptsFluidFrom(ItemStack bucket) {
        if (!ItemStackUtil.isEmpty(bucket) && bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            FluidStack fluid;
            IFluidHandlerItem handler = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            FluidStack fluidStack = fluid = handler != null ? handler.drain(1000, false) : null;
            if (fluid != null && fluid.amount > 0) {
                return 1000 == this.fill(fluid, false);
            }
        }
        return false;
    }

    public ItemStack fillFluidFrom(ItemStack bucket) {
        if (!ItemStackUtil.isEmpty(bucket) && bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            int filled;
            FluidStack fluid;
            ItemStack clone = bucket.func_77946_l();
            IFluidHandlerItem handler = (IFluidHandlerItem)clone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            FluidStack fluidStack = fluid = handler != null ? handler.drain(1000, false) : null;
            if (fluid != null && fluid.amount == 1000 && (filled = this.fill(fluid, false)) == 1000) {
                this.fill(fluid, true);
                handler.drain(filled, true);
                return handler.getContainer();
            }
        }
        return bucket;
    }
}

