/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.api.implementation.BaseTeslaContainerProvider;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.items.RegisteredItem;

public class TeslaBattery
extends RegisteredItem {
    public TeslaBattery() {
        super("teslacorelib", TeslaCoreLib.creativeTab, "battery");
        super.func_77627_a(true).func_185043_a(new ResourceLocation("power"), (stack, worldIn, entityIn) -> {
            ITeslaHolder holder = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
            if (holder == null) {
                return 0.0f;
            }
            long thing = Math.round((double)holder.getStoredPower() / (double)holder.getCapacity() * 5.0);
            return (float)Math.max(0L, Math.min(5L, thing)) * 0.2f;
        });
    }

    @Override
    protected IRecipe getRecipe() {
        return new ShapedOreRecipe(new ItemStack((Item)this, 1), new Object[]{"IRI", "RXR", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), "blockRedstone"});
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new BaseTeslaContainerProvider(new BaseTeslaContainer(10000L, 100L, 100L){});
    }

    public int getItemStackLimit(ItemStack stack) {
        ITeslaHolder tesla = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
        if (tesla == null || tesla.getStoredPower() == 0L) {
            return 16;
        }
        return 1;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ITeslaHolder holder = (ITeslaHolder)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
        if (holder != null) {
            if (holder.getStoredPower() > 0L) {
                tooltip.add(ChatFormatting.AQUA + "Power: " + holder.getStoredPower() + ChatFormatting.RESET + " of " + ChatFormatting.AQUA + holder.getCapacity());
            } else {
                tooltip.add(ChatFormatting.RED + "EMPTY!");
            }
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)new ItemStack(itemIn));
        ItemStack full = new ItemStack(itemIn);
        ITeslaHolder holder = (ITeslaHolder)full.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, null);
        ITeslaConsumer consumer = (ITeslaConsumer)full.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, null);
        if (holder != null && consumer != null) {
            int cycle = 0;
            while (holder.getCapacity() > holder.getStoredPower() && cycle++ < 100) {
                consumer.givePower(holder.getCapacity() - holder.getStoredPower(), false);
            }
        }
        subItems.add((Object)full);
    }
}

