/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.netsync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SimpleNBTMessage
implements IMessage {
    private NBTTagCompound compound = null;
    private BlockPos pos = null;
    private int dimension;

    public SimpleNBTMessage() {
    }

    public SimpleNBTMessage(TileEntity entity, NBTTagCompound compound) {
        this(entity.func_174877_v(), entity.func_145831_w().field_73011_w.getDimension(), compound);
    }

    public SimpleNBTMessage(BlockPos pos, int dimension, NBTTagCompound compound) {
        this.pos = pos;
        this.dimension = dimension;
        this.compound = compound;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.dimension;
    }

    public NBTTagCompound getCompound() {
        return this.compound;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound pos = ByteBufUtils.readTag((ByteBuf)buf);
        if (pos != null) {
            this.pos = new BlockPos(pos.func_74762_e("x"), pos.func_74762_e("y"), pos.func_74762_e("z"));
            this.dimension = pos.func_74762_e("dim");
        }
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound pos = new NBTTagCompound();
        if (this.pos != null) {
            pos.func_74768_a("x", this.pos.func_177958_n());
            pos.func_74768_a("y", this.pos.func_177956_o());
            pos.func_74768_a("z", this.pos.func_177952_p());
        }
        pos.func_74768_a("dim", this.dimension);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)pos);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)(this.compound != null ? this.compound : new NBTTagCompound()));
    }

    public NetworkRegistry.TargetPoint getTargetPoint() {
        if (this.pos != null) {
            return new NetworkRegistry.TargetPoint(this.dimension, (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 64.0);
        }
        return null;
    }
}

