/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.render;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.ndrei.teslacorelib.Utils;
import net.ndrei.teslacorelib.capabilities.TeslaCoreCapabilities;
import net.ndrei.teslacorelib.capabilities.hud.HudInfoLine;
import net.ndrei.teslacorelib.capabilities.hud.IHudInfoProvider;
import net.ndrei.teslacorelib.compatibility.FontRendererUtil;

public class HudInfoRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer<T> {
    public void func_180535_a(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        IHudInfoProvider info;
        List<HudInfoLine> lines;
        if (te.hasCapability(TeslaCoreCapabilities.CAPABILITY_HUD_INFO, null) && (lines = (info = (IHudInfoProvider)te.getCapability(TeslaCoreCapabilities.CAPABILITY_HUD_INFO, null)).getHUDLines()) != null && lines.size() > 0 && this.shouldRender(te)) {
            EnumFacing side = this.field_147501_a.field_190057_j.field_178784_b;
            if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                side = Utils.getFacingFromEntity(te.func_174877_v(), this.field_147501_a.field_147560_j, this.field_147501_a.field_147558_l);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
            switch (side) {
                case NORTH: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.5);
            super.func_190053_a(true);
            this.renderText(lines, 1.0f);
            super.func_190053_a(false);
            GlStateManager.func_179121_F();
        }
    }

    protected boolean shouldRender(T te) {
        return this.field_147501_a.field_190057_j != null && te.func_174877_v().equals((Object)this.field_147501_a.field_190057_j.func_178782_a());
    }

    private void renderText(List<HudInfoLine> messages, float scale) {
        FontRenderer font = FontRendererUtil.getFontRenderer();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)0.01f);
        float magicNumber = 0.0075f;
        GlStateManager.func_179152_a((float)(magicNumber * scale), (float)(-magicNumber * scale), (float)magicNumber);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int blockSize = Math.round(scale * 0.9f / magicNumber);
        int padding = Math.round(scale * 0.05f / magicNumber);
        int height = 11;
        int logSize = messages.size();
        int y = -height * logSize - height / 2;
        for (HudInfoLine ctl : messages) {
            if (ctl.background != null) {
                HudInfoRenderer.drawRectangle(ctl.background, true, padding, y, blockSize, height, -0.03);
            }
            if (ctl.percent > 0.0f && ctl.percentColor != null) {
                double percent = Math.max(0.0, Math.min(1.0, (double)ctl.percent));
                HudInfoRenderer.drawRectangle(ctl.percentColor, true, padding, y, (double)blockSize * percent, height, -0.02);
            }
            if (ctl.border != null) {
                HudInfoRenderer.drawRectangle(ctl.border, false, padding, y, blockSize, height, -0.01);
            }
            String line = font.func_78269_a(ctl.text, blockSize - 2);
            if (ctl.alignment == HudInfoLine.TextAlignment.LEFT) {
                font.func_78276_b(line, padding + 1, y + 2, ctl.color == null ? 0xFFFFFF : ctl.color.getRGB());
            } else {
                int textWidth = Math.min(font.func_78256_a(ctl.text), blockSize - 2);
                if (ctl.alignment == HudInfoLine.TextAlignment.RIGHT) {
                    font.func_78276_b(line, padding + 1 + blockSize - 2 - textWidth, y + 2, ctl.color == null ? 0xFFFFFF : ctl.color.getRGB());
                } else if (ctl.alignment == HudInfoLine.TextAlignment.CENTER) {
                    font.func_78276_b(line, padding + 1 + (blockSize - 2 - textWidth) / 2, y + 2, ctl.color == null ? 0xFFFFFF : ctl.color.getRGB());
                }
            }
            y += height;
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawRectangle(Color color, boolean filled, double x, double y, double width, double height, double zTranslate) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        if (!filled) {
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        } else {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(x, y + 0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + height, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b(x + width, y + 0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)zTranslate);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }
}

