/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.test;

import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.tileentities.ElectricMachine;

public final class TeslaCoreUITestEntity
extends ElectricMachine {
    private IFluidTank waterTank;
    private IFluidTank lavaTank;
    private ItemStackHandler inputs;
    private ItemStackHandler outputs;

    public TeslaCoreUITestEntity() {
        super(-1);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.waterTank = super.addFluidTank(FluidRegistry.WATER, 5000, EnumDyeColor.BLUE, "Water Tank", new BoundingRectangle(43, 25, 18, 54));
        this.lavaTank = super.addFluidTank(FluidRegistry.LAVA, 5000, EnumDyeColor.RED, "Lava Tank", new BoundingRectangle(61, 25, 18, 54));
        super.ensureFluidItems();
        this.inputs = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                TeslaCoreUITestEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inputs, EnumDyeColor.GREEN, "Input Items", new BoundingRectangle(115, 25, 54, 18)){

            @Override
            public boolean canExtractItem(int slot) {
                return false;
            }

            @Override
            public List<Slot> getSlots(BasicTeslaContainer container) {
                List<Slot> slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                for (int x = 0; x < 3; ++x) {
                    slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), x, box.getLeft() + 1 + x * 18, box.getTop() + 1));
                }
                return slots;
            }

            @Override
            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 3, 1, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.GREEN));
                return pieces;
            }
        });
        this.outputs = new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                TeslaCoreUITestEntity.this.func_70296_d();
            }
        };
        super.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.outputs, EnumDyeColor.PURPLE, "Output Items", new BoundingRectangle(115, 43, 54, 36)){

            @Override
            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            @Override
            public List<Slot> getSlots(BasicTeslaContainer container) {
                List<Slot> slots = super.getSlots(container);
                BoundingRectangle box = this.getBoundingBox();
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 2; ++y) {
                        slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), y * 3 + x, box.getLeft() + 1 + x * 18, box.getTop() + 1 + y * 18));
                    }
                }
                return slots;
            }

            @Override
            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                pieces.add(new TiledRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 18, 3, 2, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 108, 225, EnumDyeColor.PURPLE));
                return pieces;
            }
        });
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt;
        compound = super.func_189515_b(compound);
        if (this.inputs != null && (nbt = this.inputs.serializeNBT()) != null) {
            compound.func_74782_a("inv_inputs", (NBTBase)nbt);
        }
        if (this.outputs != null && (nbt = this.outputs.serializeNBT()) != null) {
            compound.func_74782_a("inv_outputs", (NBTBase)nbt);
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("inv_inputs", 10) && this.inputs != null) {
            this.inputs.deserializeNBT(compound.func_74775_l("inv_inputs"));
        }
        if (compound.func_150297_b("inv_outputs", 10) && this.outputs != null) {
            this.outputs.deserializeNBT(compound.func_74775_l("inv_outputs"));
        }
    }

    @Override
    protected float performWork() {
        float result = 0.0f;
        if (this.waterTank != null && this.lavaTank != null && this.outputs != null) {
            FluidStack water = this.waterTank.drain(250, false);
            FluidStack lava = this.lavaTank.drain(125, false);
            if (water != null && water.amount == 250 && lava != null && lava.amount == 125) {
                ItemStack cobble = new ItemStack(Blocks.field_150347_e, 1);
                if (ItemStackUtil.isEmpty(cobble = ItemHandlerHelper.insertItem((IItemHandler)this.outputs, (ItemStack)cobble, (boolean)false))) {
                    this.waterTank.drain(250, true);
                    this.lavaTank.drain(125, true);
                    result = 0.25f;
                }
            }
        }
        if (this.inputs != null && this.outputs != null) {
            boolean moved = true;
            block0: while (moved && result <= 0.85f) {
                moved = false;
                for (int x = 0; x < 3; ++x) {
                    ItemStack stack = this.inputs.extractItem(x, 1, true);
                    if (ItemStackUtil.isEmpty(stack) || !ItemStackUtil.isEmpty(stack = ItemHandlerHelper.insertItem((IItemHandler)this.outputs, (ItemStack)stack, (boolean)false))) continue;
                    this.inputs.extractItem(x, 1, false);
                    result += 0.15f;
                    moved = true;
                    continue block0;
                }
            }
        }
        return result;
    }
}

