/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.tileentities;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TeslaEnergyLevelPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.EnergyStorage;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public abstract class ElectricTileEntity
extends SidedTileEntity {
    protected EnergyStorage energyStorage;

    protected ElectricTileEntity(int typeId) {
        super(typeId);
    }

    @Override
    protected void initializeInventories() {
        this.energyStorage = new EnergyStorage(this.getMaxEnergy(), this.getEnergyInputRate(), this.getEnergyOutputRate()){

            @Override
            public void onChanged() {
                ElectricTileEntity.this.func_70296_d();
                ElectricTileEntity.this.forceSync();
            }
        };
        this.energyStorage.setSidedConfig(EnumDyeColor.LIGHT_BLUE, this.sideConfig, this.getEnergyBoundingBox());
        super.initializeInventories();
    }

    protected BoundingRectangle getEnergyBoundingBox() {
        return new BoundingRectangle(7, 25, 18, 54);
    }

    protected long getMaxEnergy() {
        return 50000L;
    }

    protected long getEnergyInputRate() {
        return 80L;
    }

    protected long getEnergyOutputRate() {
        return 0L;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("energy")) {
            this.energyStorage.deserializeNBT(compound.func_74775_l("energy"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("energy", (NBTBase)this.energyStorage.serializeNBT());
        return compound;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        EnumFacing oriented = this.orientFacing(facing);
        if (this.energyStorage != null && this.energyStorage.hasCapability(capability, oriented)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        T c;
        EnumFacing oriented = this.orientFacing(facing);
        if (this.energyStorage != null && (c = this.energyStorage.getCapability(capability, oriented)) != null) {
            return c;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        BoundingRectangle energyBox = this.getEnergyBoundingBox();
        if (energyBox != null) {
            pieces.add(new TeslaEnergyLevelPiece(energyBox.getLeft(), energyBox.getTop(), this.energyStorage));
        }
        return pieces;
    }

    @Override
    public final void innerUpdate() {
        this.protectedUpdate();
        this.energyStorage.processStatistics();
    }

    protected abstract void protectedUpdate();
}

