/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.tileentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.blocks.OrientedBlock;
import net.ndrei.teslacorelib.capabilities.TeslaCoreCapabilities;
import net.ndrei.teslacorelib.capabilities.container.IGuiContainerProvider;
import net.ndrei.teslacorelib.capabilities.hud.HudInfoLine;
import net.ndrei.teslacorelib.capabilities.hud.IHudInfoProvider;
import net.ndrei.teslacorelib.capabilities.inventory.SidedItemHandlerConfig;
import net.ndrei.teslacorelib.capabilities.wrench.ITeslaWrenchHandler;
import net.ndrei.teslacorelib.compatibility.ItemStackUtil;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.containers.IContainerSlotsProvider;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.IGuiContainerPiecesProvider;
import net.ndrei.teslacorelib.gui.MachineNameGuiPiece;
import net.ndrei.teslacorelib.gui.PlayerInventoryBackground;
import net.ndrei.teslacorelib.gui.SideConfigSelector;
import net.ndrei.teslacorelib.gui.SideConfigurator;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredFluidHandler;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.FluidTank;
import net.ndrei.teslacorelib.inventory.SidedFluidHandler;
import net.ndrei.teslacorelib.inventory.SidedItemHandler;
import net.ndrei.teslacorelib.items.BaseAddon;
import net.ndrei.teslacorelib.items.TeslaWrench;
import net.ndrei.teslacorelib.netsync.ISimpleNBTMessageHandler;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;

public abstract class SidedTileEntity
extends TileEntity
implements ITickable,
IHudInfoProvider,
ISimpleNBTMessageHandler,
IGuiContainerProvider,
ITeslaWrenchHandler {
    private static final int SYNC_ON_TICK = 20;
    private int syncTick = 20;
    private SidedItemHandler itemHandler;
    private List<InventoryStorageInfo> inventoryStorage;
    protected SidedFluidHandler fluidHandler;
    private ItemStackHandler fluidItems = null;
    protected ItemStackHandler addonItems;
    private int typeId;
    protected SidedItemHandlerConfig sideConfig;
    private boolean wasPickedUpInItemStack = false;

    protected SidedTileEntity(int typeId) {
        this.typeId = typeId;
        this.sideConfig = new SidedItemHandlerConfig(){

            @Override
            protected void updated() {
                SidedTileEntity.this.notifyNeighbours();
            }
        };
        this.itemHandler = new SidedItemHandler(this.sideConfig);
        this.fluidHandler = new SidedFluidHandler(this.sideConfig);
        this.initializeInventories();
        this.ensureFluidItems();
    }

    private void notifyNeighbours() {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    protected void initializeInventories() {
        this.createAddonsInventory();
    }

    protected void createAddonsInventory() {
        this.addonItems = new ItemStackHandler(4){
            private ItemStack[] items;
            {
                this.items = new ItemStack[]{null, null, null, null};
            }

            protected void onContentsChanged(int slot) {
                this.testSlot(slot);
            }

            protected void onLoad() {
                for (int index = 0; index < this.getSlots(); ++index) {
                    this.testSlot(index);
                }
            }

            private void testSlot(int slot) {
                Item item;
                ItemStack stack = this.getStackInSlot(slot).func_77946_l();
                Item item2 = item = ItemStackUtil.isEmpty(stack) ? null : stack.func_77973_b();
                if (!(item instanceof BaseAddon)) {
                    item = null;
                } else {
                    stack = stack.func_77946_l();
                }
                if (item == null && this.items[slot] != null) {
                    ((BaseAddon)this.items[slot].func_77973_b()).onRemoved(this.items[slot], SidedTileEntity.this);
                    this.items[slot] = null;
                } else if (item != null && this.items[slot] == null) {
                    this.items[slot] = stack;
                    ((BaseAddon)item).onAdded(this.items[slot], SidedTileEntity.this);
                } else if (item != null && this.items[slot] != null && !ItemStack.func_77989_b((ItemStack)this.items[slot], (ItemStack)stack)) {
                    ((BaseAddon)this.items[slot].func_77973_b()).onRemoved(this.items[slot], SidedTileEntity.this);
                    this.items[slot] = stack;
                    ((BaseAddon)item).onAdded(this.items[slot], SidedTileEntity.this);
                }
                SidedTileEntity.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.addonItems, null, null, null){

            @Override
            public boolean canInsertItem(int slot, ItemStack stack) {
                return SidedTileEntity.this.isValidAddonItem(stack);
            }

            @Override
            public boolean canExtractItem(int slot) {
                return false;
            }

            @Override
            public List<Slot> getSlots(BasicTeslaContainer container) {
                List<Slot> slots = super.getSlots(container);
                for (int y = 0; y < 4; ++y) {
                    slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), y, 174, 8 + y * 18));
                }
                return slots;
            }

            @Override
            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                pieces.add(new TiledRenderedGuiPiece(173, 7, 18, 18, 1, 4, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 144, 190, null));
                return pieces;
            }
        });
    }

    protected <T extends BaseAddon> T getAddon(Class<T> addonClass) {
        if (this.addonItems != null && addonClass != null) {
            for (int index = 0; index < this.addonItems.getSlots(); ++index) {
                Item item;
                ItemStack stack = this.addonItems.getStackInSlot(index);
                if (ItemStackUtil.isEmpty(stack) || !addonClass.isAssignableFrom((item = stack.func_77973_b()).getClass())) continue;
                return (T)((Object)((BaseAddon)item));
            }
        }
        return null;
    }

    protected <T extends BaseAddon> ItemStack getAddonStack(Class<T> addonClass) {
        if (this.addonItems != null && addonClass != null) {
            for (int index = 0; index < this.addonItems.getSlots(); ++index) {
                ItemStack stack = this.addonItems.getStackInSlot(index);
                if (ItemStackUtil.isEmpty(stack) || !addonClass.isAssignableFrom(stack.func_77973_b().getClass())) continue;
                return stack;
            }
        }
        return ItemStackUtil.getEmptyStack();
    }

    protected <T extends BaseAddon> boolean hasAddon(Class<T> addonClass) {
        return null != this.getAddon(addonClass);
    }

    public List<BaseAddon> getAddons() {
        ArrayList list = Lists.newArrayList();
        if (this.addonItems != null) {
            for (int index = 0; index < this.addonItems.getSlots(); ++index) {
                Item item;
                ItemStack stack = this.addonItems.getStackInSlot(index);
                if (ItemStackUtil.isEmpty(stack) || !((item = stack.func_77973_b()) instanceof BaseAddon)) continue;
                list.add((BaseAddon)item);
            }
        }
        return list;
    }

    protected boolean isValidAddonItem(ItemStack stack) {
        BaseAddon addon;
        Item item;
        return !ItemStackUtil.isEmpty(stack) && (item = stack.func_77973_b()) instanceof BaseAddon && (addon = (BaseAddon)item).canBeAddedTo(this);
    }

    public ItemStack removeAddon(BaseAddon addon, boolean drop) {
        if (this.addonItems != null && !this.func_145831_w().field_72995_K) {
            for (int index = 0; index < this.addonItems.getSlots(); ++index) {
                ItemStack stack = this.addonItems.getStackInSlot(index);
                if (ItemStackUtil.isEmpty(stack) || stack.func_77973_b() != addon) continue;
                this.addonItems.setStackInSlot(index, ItemStackUtil.getEmptyStack());
                if (drop) {
                    this.spawnItemFromFrontSide(stack);
                }
                return stack;
            }
        }
        return ItemStackUtil.getEmptyStack();
    }

    protected void addInventory(IItemHandler handler) {
        ColoredItemHandler colored;
        if (handler == null) {
            return;
        }
        this.itemHandler.addItemHandler(handler);
        if (handler instanceof ColoredItemHandler && (colored = (ColoredItemHandler)handler).getColor() != null && colored.getBoundingBox() != null) {
            this.sideConfig.addColoredInfo(colored.getName(), colored.getColor(), colored.getBoundingBox());
        }
    }

    protected void addInventoryToStorage(ItemStackHandler handler, String storageKey) {
        if (this.inventoryStorage == null) {
            this.inventoryStorage = Lists.newArrayList();
        }
        this.inventoryStorage.add(new InventoryStorageInfo(handler, storageKey));
    }

    protected IFluidTank addFluidTank(Fluid filter, int capacity, EnumDyeColor color, String name, BoundingRectangle boundingBox) {
        FluidTank tank = new FluidTank(capacity){

            protected void onContentsChanged() {
                SidedTileEntity.this.func_70296_d();
            }
        };
        ColoredFluidHandler colored = this.fluidHandler.addTank(filter, tank, color, name, boundingBox);
        if (color != null && name != null && name.length() > 0 && boundingBox != null) {
            this.sideConfig.addColoredInfo(name, color, boundingBox);
        }
        return colored.getInnerTank();
    }

    protected void addFluidTank(IFluidTank tank, BoundingRectangle box) {
        if (tank == null) {
            return;
        }
        this.fluidHandler.addTank(tank);
        if (tank instanceof ColoredFluidHandler) {
            ColoredFluidHandler colored = (ColoredFluidHandler)tank;
            if (box == null) {
                box = colored.getBoundingBox();
            }
            if (box != null && colored.getColor() != null) {
                this.sideConfig.addColoredInfo(colored.getName(), colored.getColor(), box);
            }
        }
    }

    protected void addFluidTank(IFluidTank tank, EnumDyeColor color, String name, BoundingRectangle boundingBox) {
        if (color != null && name != null && name.length() > 0 && boundingBox != null) {
            this.fluidHandler.addTank(new ColoredFluidHandler(tank, color, name, boundingBox));
            this.sideConfig.addColoredInfo(name, color, boundingBox);
        } else {
            this.fluidHandler.addTank(tank);
        }
    }

    protected void removeFluidTank(EnumDyeColor color, IFluidTank tank) {
        this.fluidHandler.removeTank(tank);
        this.sideConfig.removeColoredInfo(color);
        this.func_70296_d();
    }

    protected EnumDyeColor getColorForFluidInventory() {
        return EnumDyeColor.SILVER;
    }

    protected void ensureFluidItems() {
        EnumDyeColor color;
        if (!this.shouldAddFluidItemsInventory()) {
            return;
        }
        if (this.fluidItems == null && (color = this.getColorForFluidInventory()) != null) {
            BoundingRectangle box = this.getFluidItemsBoundingBox();
            this.fluidItems = new ItemStackHandler(2){};
            this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.fluidItems, color, "Fluid Containers", box){

                @Override
                public boolean canInsertItem(int slot, ItemStack stack) {
                    return slot == 0 && SidedTileEntity.this.acceptsFluidItem(stack);
                }

                @Override
                public boolean canExtractItem(int slot) {
                    return slot != 0;
                }

                @Override
                public List<Slot> getSlots(BasicTeslaContainer container) {
                    List<Slot> slots = super.getSlots(container);
                    BoundingRectangle box = this.getBoundingBox();
                    if (box != null) {
                        slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1, box.getTop() + 1));
                        slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 1, box.getLeft() + 1, box.getTop() + 1 + 36));
                    }
                    return slots;
                }

                @Override
                public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                    List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                    BoundingRectangle box = this.getBoundingBox();
                    if (box != null) {
                        SidedTileEntity.this.addFluidItemsBackground(pieces, box);
                    }
                    return pieces;
                }
            });
        }
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return this.fluidHandler != null && this.fluidHandler.acceptsFluidFrom(stack);
    }

    protected BoundingRectangle getFluidItemsBoundingBox() {
        int x = 0;
        int y = 0;
        for (IFluidTank tank : this.fluidHandler.getTanks()) {
            BoundingRectangle box;
            if (!(tank instanceof ColoredFluidHandler) || (box = ((ColoredFluidHandler)tank).getBoundingBox()) == null) continue;
            x = Math.max(x, box.getRight());
            y = box.getTop();
        }
        return new BoundingRectangle(x, y, 18, 54);
    }

    protected void addFluidItemsBackground(List<IGuiContainerPiece> pieces, BoundingRectangle box) {
        pieces.add(new BasicRenderedGuiPiece(box.getLeft(), box.getTop(), 18, 54, BasicTeslaGuiContainer.MACHINE_BACKGROUND, 78, 189));
    }

    protected boolean shouldAddFluidItemsInventory() {
        return this.fluidHandler != null && this.fluidHandler.tankCount() != 0;
    }

    public EnumFacing getFacing() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof OrientedBlock) {
            return (EnumFacing)state.func_177229_b((IProperty)OrientedBlock.FACING);
        }
        return EnumFacing.NORTH;
    }

    protected int getEntityTypeId() {
        return this.typeId;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("addonItems") && this.addonItems != null) {
            this.addonItems.deserializeNBT(compound.func_74775_l("addonItems"));
        }
        if (compound.func_74764_b("fluids")) {
            this.fluidHandler.deserializeNBT(compound.func_74775_l("fluids"));
        }
        if (compound.func_74764_b("fluidItems") && this.fluidItems != null) {
            this.fluidItems.deserializeNBT(compound.func_74775_l("fluidItems"));
        }
        this.syncTick = compound.func_74762_e("tick_sync");
        if (compound.func_150297_b("side_config", 9)) {
            NBTTagList list = compound.func_150295_c("side_config", 10);
            this.sideConfig.deserializeNBT(list);
        }
        if (this.inventoryStorage != null && !this.inventoryStorage.isEmpty()) {
            for (InventoryStorageInfo storage : this.inventoryStorage) {
                if (!compound.func_150297_b(storage.storageKey, 10)) continue;
                storage.inventory.deserializeNBT(compound.func_74775_l(storage.storageKey));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("fluids", (NBTBase)this.fluidHandler.serializeNBT());
        if (this.fluidItems != null) {
            compound.func_74782_a("fluidItems", (NBTBase)this.fluidItems.serializeNBT());
        }
        if (this.addonItems != null) {
            compound.func_74782_a("addonItems", (NBTBase)this.addonItems.serializeNBT());
        }
        compound.func_74768_a("tick_sync", this.syncTick);
        compound.func_74782_a("side_config", (NBTBase)this.sideConfig.serializeNBT());
        if (this.inventoryStorage != null && !this.inventoryStorage.isEmpty()) {
            for (InventoryStorageInfo storage : this.inventoryStorage) {
                compound.func_74782_a(storage.storageKey, (NBTBase)storage.inventory.serializeNBT());
            }
        }
        return compound;
    }

    private NBTTagCompound writeToNBT() {
        NBTTagCompound compound = this.setupSpecialNBTMessage(null);
        return this.func_189515_b(compound);
    }

    public NBTTagCompound setupSpecialNBTMessage(String messageType) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("__tetId", this.getEntityTypeId());
        if (messageType != null && messageType.length() > 0) {
            compound.func_74778_a("__messageType", messageType);
        }
        return compound;
    }

    @Override
    public SimpleNBTMessage handleMessage(SimpleNBTMessage message) {
        NBTTagCompound compound;
        NBTTagCompound nBTTagCompound = compound = message == null ? null : message.getCompound();
        if (compound != null) {
            int tetId = compound.func_74762_e("__tetId");
            if (tetId == this.getEntityTypeId()) {
                if (compound.func_150297_b("__messageType", 8)) {
                    String messageType = compound.func_74779_i("__messageType");
                    if (this.func_145831_w().field_72995_K) {
                        return this.processServerMessage(messageType, compound);
                    }
                    return this.processClientMessage(messageType, compound);
                }
                if (this.func_145831_w().field_72995_K) {
                    this.processServerMessage(compound);
                }
            } else {
                TeslaCoreLib.logger.info("Unknown message for __tetId: " + tetId + " : " + compound.toString());
            }
        }
        return null;
    }

    protected void processServerMessage(NBTTagCompound compound) {
        this.func_145839_a(compound);
    }

    protected SimpleNBTMessage processServerMessage(String messageType, NBTTagCompound compound) {
        return null;
    }

    protected SimpleNBTMessage processClientMessage(String messageType, NBTTagCompound compound) {
        if (messageType != null && messageType.equals("TOGGLE_SIDE")) {
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)compound.func_74762_e("color"));
            EnumFacing facing = EnumFacing.func_82600_a((int)compound.func_74762_e("side"));
            this.sideConfig.toggleSide(color, facing);
            this.func_70296_d();
        }
        return null;
    }

    protected EnumFacing orientFacing(EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return facing;
        }
        EnumFacing machineFacing = this.getFacing();
        if (machineFacing == EnumFacing.EAST) {
            return facing.func_176746_e();
        }
        if (machineFacing == EnumFacing.NORTH) {
            return facing.func_176734_d();
        }
        if (machineFacing == EnumFacing.WEST) {
            return facing.func_176735_f();
        }
        return facing;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        EnumFacing oriented = this.orientFacing(facing);
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            int[] slots = this.itemHandler.getSlotsForFace(oriented);
            return slots != null && slots.length > 0;
        }
        if (capability == TeslaCoreCapabilities.CAPABILITY_HUD_INFO) {
            return true;
        }
        if (capability == TeslaCoreCapabilities.CAPABILITY_GUI_CONTAINER) {
            return true;
        }
        if (capability == TeslaCoreCapabilities.CAPABILITY_WRENCH) {
            return true;
        }
        if (this.fluidHandler != null && this.fluidHandler.hasCapability(capability, oriented)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        T c;
        EnumFacing oriented = this.orientFacing(facing);
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler.getSideWrapper(oriented);
        }
        if (capability == TeslaCoreCapabilities.CAPABILITY_HUD_INFO) {
            return (T)this;
        }
        if (capability == TeslaCoreCapabilities.CAPABILITY_GUI_CONTAINER) {
            return (T)this;
        }
        if (capability == TeslaCoreCapabilities.CAPABILITY_WRENCH) {
            return (T)this;
        }
        if (this.fluidHandler != null && (c = this.fluidHandler.getCapability(capability, oriented)) != null) {
            return c;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public List<HudInfoLine> getHUDLines() {
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumActionResult onWrenchUse(TeslaWrench wrench, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world == null || !world.equals(this.func_145831_w()) || pos == null || !pos.equals((Object)this.func_174877_v())) {
            return EnumActionResult.PASS;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (player.func_70093_af()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74782_a("tileentity", (NBTBase)this.writeToNBT());
                ItemStack stack = new ItemStack(Item.func_150898_a((Block)this.func_145838_q()), 1);
                stack.func_77982_d(nbt);
                BlockPos spawnPos = this.func_174877_v();
                this.wasPickedUpInItemStack = true;
                this.func_145831_w().func_175698_g(spawnPos);
                this.spawnItem(stack, spawnPos);
            } else if (this.func_145838_q() instanceof OrientedBlock) {
                try {
                    EnumActionResult enumActionResult = this.func_145838_q().rotateBlock(this.func_145831_w(), this.func_174877_v(), EnumFacing.UP) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
                    return enumActionResult;
                }
                finally {
                    this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public BasicTeslaContainer getContainer(int id, EntityPlayer player) {
        return new BasicTeslaContainer<SidedTileEntity>(this, player);
    }

    @Override
    public BasicTeslaGuiContainer getGuiContainer(int id, EntityPlayer player) {
        return new BasicTeslaGuiContainer<SidedTileEntity>(id, this.getContainer(id, player), this);
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        ArrayList pieces = Lists.newArrayList();
        pieces.add(new MachineNameGuiPiece(this.func_145838_q().func_149739_a() + ".name", 7, 7, 162, 12));
        pieces.add(new PlayerInventoryBackground(7, 101, 162, 54));
        SideConfigurator configurator = new SideConfigurator(7, 101, 162, 54, this.sideConfig, this);
        pieces.add(configurator);
        pieces.add(new SideConfigSelector(7, 81, 162, 18, this.sideConfig, configurator));
        for (int i = 0; i < this.itemHandler.getInventories(); ++i) {
            List<IGuiContainerPiece> childPieces;
            IItemHandler handler = this.itemHandler.getInventory(i);
            if (!(handler instanceof IGuiContainerPiecesProvider) || (childPieces = ((IGuiContainerPiecesProvider)handler).getGuiContainerPieces(container)) == null || childPieces.size() <= 0) continue;
            pieces.addAll(childPieces);
        }
        List<IGuiContainerPiece> fluidPieces = this.fluidHandler.getGuiContainerPieces(container);
        if (fluidPieces != null && fluidPieces.size() > 0) {
            pieces.addAll(fluidPieces);
        }
        return pieces;
    }

    @Override
    public List<Slot> getSlots(BasicTeslaContainer container) {
        ArrayList slots = Lists.newArrayList();
        for (int i = 0; i < this.itemHandler.getInventories(); ++i) {
            List<Slot> childSlots;
            IItemHandler handler = this.itemHandler.getInventory(i);
            if (!(handler instanceof IContainerSlotsProvider) || (childSlots = ((IContainerSlotsProvider)handler).getSlots(container)) == null || childSlots.size() <= 0) continue;
            slots.addAll(childSlots);
        }
        return slots;
    }

    public final void func_73660_a() {
        this.innerUpdate();
        this.processImmediateInventories();
        if (!this.func_145831_w().field_72995_K) {
            ++this.syncTick;
            if (this.syncTick >= 20) {
                TeslaCoreLib.network.send(new SimpleNBTMessage(this, this.writeToNBT()));
                this.syncTick = 0;
            }
        }
    }

    protected abstract void innerUpdate();

    protected void forceSync() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.syncTick = 20;
        }
    }

    protected void processImmediateInventories() {
        if (this.fluidItems != null) {
            this.processFluidItems(this.fluidItems);
        }
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStack stack = fluidItems.getStackInSlot(0);
        if (!ItemStackUtil.isEmpty(stack) && this.fluidHandler.acceptsFluidFrom(stack)) {
            ItemStack result = this.fluidHandler.fillFluidFrom(stack);
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)result)) {
                fluidItems.setStackInSlot(0, result);
                this.discardUsedFluidItem();
            }
        } else if (!ItemStackUtil.isEmpty(stack)) {
            this.discardUsedFluidItem();
        }
    }

    protected void discardUsedFluidItem() {
        if (this.fluidItems != null) {
            ItemStack source = this.fluidItems.getStackInSlot(0);
            ItemStack result = this.fluidItems.insertItem(1, source, false);
            this.fluidItems.setStackInSlot(0, result);
        }
    }

    public final void onBlockBroken() {
        if (!this.wasPickedUpInItemStack) {
            this.processBlockBroken();
        }
    }

    protected void processBlockBroken() {
        if (this.itemHandler != null) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (ItemStackUtil.isEmpty(stack)) continue;
                InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
            }
        }
    }

    public EntityItem spawnItemFromFrontSide(ItemStack stack) {
        BlockPos spawnPos = this.field_174879_c.func_177972_a(this.getFacing());
        return this.spawnItem(stack, spawnPos);
    }

    public EntityItem spawnItem(ItemStack stack, BlockPos spawnPos) {
        if (ItemStackUtil.isEmpty(stack) || this.func_145831_w().field_72995_K) {
            return null;
        }
        EntityItem entity = new EntityItem(this.func_145831_w(), (double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5, stack);
        this.func_145831_w().func_72838_d((Entity)entity);
        return entity;
    }

    private final class InventoryStorageInfo {
        final ItemStackHandler inventory;
        final String storageKey;

        InventoryStorageInfo(ItemStackHandler inventory, String storageKey) {
            this.inventory = inventory;
            this.storageKey = storageKey;
        }
    }
}

