/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile;

import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.item.addon.RedstoneInvertedAddon;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.tile.mob.MobDetectorTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.items.SpeedUpgradeTier1;
import net.ndrei.teslacorelib.items.SpeedUpgradeTier2;

public abstract class WorkingAreaElectricMachine
extends CustomElectricMachine {
    private int color = CommonProxy.random.nextInt();
    private boolean showArea;
    private int radius;
    private int height;
    private boolean acceptsRangeAddon;

    protected WorkingAreaElectricMachine(int typeId, int radius, int height, boolean acceptsRangeAddon) {
        super(typeId);
        this.radius = radius;
        this.height = height;
        this.acceptsRangeAddon = acceptsRangeAddon;
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List list = super.getGuiContainerPieces(container);
        list.add(new ToggleButtonPiece(153, 84, 14, 14){

            protected int getCurrentState() {
                return WorkingAreaElectricMachine.this.showArea ? 1 : 0;
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
            }

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (this.getCurrentState() == 0) {
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 78, 1, 16, 16);
                } else {
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 78, 17, 16, 16);
                }
            }

            protected void clicked() {
                WorkingAreaElectricMachine.this.showArea = !WorkingAreaElectricMachine.this.showArea;
            }

            public void drawForegroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
                if (this.isInside(container, mouseX, mouseY)) {
                    container.drawTooltip(Arrays.asList("Show working area"), mouseX - guiX, mouseY - guiY);
                }
            }
        });
        return list;
    }

    public abstract float work();

    protected float performWork() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c) == !this.hasAddon(RedstoneInvertedAddon.class) && !(this instanceof MobDetectorTile)) {
            return 0.0f;
        }
        float work = 0.0f;
        for (int i = 0; i < this.getActionsWork(); ++i) {
            float temp = this.work();
            if (temp < 0.0f) {
                return 1.0f;
            }
            if (!(temp > work)) continue;
            work = temp;
        }
        return work;
    }

    public abstract AxisAlignedBB getWorkingArea();

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        return this.color;
    }

    public boolean isShowArea() {
        return this.showArea;
    }

    public int getRadius() {
        return this.radius + (this.hasAddon(RangeAddonItem.class) ? (this.getAddonStack(RangeAddonItem.class).func_77960_j() <= 0 ? -1 : this.getAddonStack(RangeAddonItem.class).func_77960_j()) : 0);
    }

    public int getHeight() {
        return this.height;
    }

    public boolean canAcceptRangeUpgrades() {
        return this.acceptsRangeAddon;
    }

    public int getActionsWork() {
        return 1 + this.getRadius() / 4 * this.speedUpgradeLevel();
    }

    public int speedUpgradeLevel() {
        if (this.hasAddon(SpeedUpgradeTier2.class)) {
            return 2;
        }
        if (this.hasAddon(SpeedUpgradeTier1.class)) {
            return 1;
        }
        return 0;
    }
}

