/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.generator.BioReactorTile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.ndrei.teslacorelib.TeslaCoreLib;

public class BioReactorBlock
extends CustomOrientedBlock<BioReactorTile> {
    private List<ItemStack> itemsAccepted = new ArrayList<ItemStack>();
    private int baseAmount;

    public BioReactorBlock() {
        super("bioreactor", BioReactorTile.class, Material.field_151576_e, 2000, 10);
    }

    @Override
    public void getMachineConfig() {
        String[] items;
        super.getMachineConfig();
        this.baseAmount = CustomConfiguration.config.getInt("baseBiofuel", "machines." + this.getRegistryName().func_110623_a().toString(), 80, 1, 4000, "Base biofuel amount in mb");
        for (String s : items = CustomConfiguration.config.getStringList("acceptedItems", "machines." + this.getRegistryName().func_110623_a().toString(), new String[]{"minecraft:wheat_seeds", "minecraft:pumpkin_seeds", "minecraft:melon_seeds", "minecraft:beetroot_seeds", "treeSapling", "minecraft:carrot", "minecraft:potato", "minecraft:nether_wart", "minecraft:brown_mushroom", "minecraft:red_mushroom", "dye", "minecraft:chorus_flower"}, "It can accept oreDictionary entries and item ids")) {
            if (s.contains(":")) {
                if (Item.func_111206_d((String)s) == null) continue;
                this.itemsAccepted.add(new ItemStack(Item.func_111206_d((String)s)));
                continue;
            }
            this.itemsAccepted.addAll((Collection<ItemStack>)OreDictionary.getOres((String)s));
        }
    }

    public List<ItemStack> getItemsAccepted() {
        return this.itemsAccepted;
    }

    public int getBaseAmount() {
        return this.baseAmount;
    }

    protected IRecipe getRecipe() {
        return new ShapedOreRecipe(new ItemStack((Block)this), new Object[]{"pep", "sms", "bcb", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('e'), Items.field_151071_bq, Character.valueOf('s'), Items.field_151123_aH, Character.valueOf('m'), TeslaCoreLib.machineCase, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('c'), Items.field_151102_aT});
    }
}

