/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.magic;

import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.PotionItems;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class PotionEnervatorTile
extends CustomElectricMachine {
    private static final String NBT_ACTION = "action";
    private IFluidTank fluidTank;
    private ItemStackHandler inputGlassBottles;
    private ItemStackHandler inputIngredients;
    private ItemStackHandler outputPotions;
    private int action = 0;

    public PotionEnervatorTile() {
        super(PotionEnervatorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.initInputInventories();
        this.initOutputInventories();
    }

    private void initInputInventories() {
        this.fluidTank = this.addFluidTank(FluidRegistry.WATER, 8000, EnumDyeColor.BLUE, "Water tank", new BoundingRectangle(44, 25, 18, 54));
        this.inputGlassBottles = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                PotionEnervatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inputGlassBottles, EnumDyeColor.ORANGE, "Glass bottles input", 82, 61, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals(Items.field_151069_bo);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inputGlassBottles, "pot_ener_in_glass");
        this.inputIngredients = new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                PotionEnervatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inputIngredients, EnumDyeColor.GREEN, "Ingredients items", 82, 25, 5, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                if (stack.func_77973_b().equals(Items.field_151069_bo)) {
                    return false;
                }
                if (slot == 0) {
                    return stack.func_77973_b().equals(Items.field_151075_bm);
                }
                return !stack.func_77973_b().equals(Items.field_151075_bm);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inputIngredients, "pot_ener_in");
    }

    private void initOutputInventories() {
        this.outputPotions = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                PotionEnervatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outputPotions, EnumDyeColor.PURPLE, "Potions items", 118, 61, 3, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outputPotions, "pot_ener_out");
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new BasicRenderedGuiPiece(0, 0, 16, 16, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 16, 16){

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                container.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialforegoing", "textures/gui/machines.png"));
                if (PotionEnervatorTile.this.action == 0) {
                    container.drawTexturedRect(83, 44, 78, 48, 15, 15);
                } else {
                    container.drawTexturedRect(18 * (PotionEnervatorTile.this.action + 3) + 11, 43, 78, 32, 15, 15);
                }
            }

            public void drawForegroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
                if (PotionEnervatorTile.this.action == 0) {
                    if (mouseX - guiX > 83 && mouseY - guiY > 44 && mouseX - guiX < 98 && mouseY - guiY <= 59) {
                        container.drawTooltip(Arrays.asList("Filling with water"), mouseX - guiX, mouseY - guiY);
                    }
                } else if (mouseX - guiX > 18 * (PotionEnervatorTile.this.action + 3) + 11 && mouseY - guiY > 43 && mouseX - guiX < 18 * (PotionEnervatorTile.this.action + 3) + 11 + 15 && mouseY - guiY <= 58) {
                    container.drawTooltip(Arrays.asList("Adding ingredient"), mouseX - guiX, mouseY - guiY);
                }
            }
        });
        pieces.add(new BasicRenderedGuiPiece(82, 61, 0, 0, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 0, 0){

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
            }

            public void drawMiddleLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawMiddleLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (PotionEnervatorTile.this.inputGlassBottles.getStackInSlot(0).func_190926_b()) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151069_bo), container.getGuiLeft() + 72 + 11, container.getGuiTop() + 26 + 36, 8);
                }
                if (PotionEnervatorTile.this.inputIngredients.getStackInSlot(0).func_190926_b()) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151075_bm), container.getGuiLeft() + 72 + 11, container.getGuiTop() + 26, 8);
                }
                if (PotionEnervatorTile.this.inputIngredients.getStackInSlot(1).func_190926_b()) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151137_ax), container.getGuiLeft() + 90 + 11, container.getGuiTop() + 26, 9);
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151016_H), container.getGuiLeft() + 90 + 11, container.getGuiTop() + 26, 8);
                }
                if (PotionEnervatorTile.this.inputIngredients.getStackInSlot(2).func_190926_b()) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151102_aT), container.getGuiLeft() + 108 + 11, container.getGuiTop() + 26, 9);
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151114_aO), container.getGuiLeft() + 108 + 11, container.getGuiTop() + 26, 8);
                }
                if (PotionEnervatorTile.this.inputIngredients.getStackInSlot(3).func_190926_b()) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151071_bq), container.getGuiLeft() + 126 + 11, container.getGuiTop() + 26, 9);
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151064_bs), container.getGuiLeft() + 126 + 11, container.getGuiTop() + 26, 8);
                }
                if (PotionEnervatorTile.this.inputIngredients.getStackInSlot(4).func_190926_b()) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151073_bk), container.getGuiLeft() + 144 + 11, container.getGuiTop() + 26, 9);
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_185157_bK), container.getGuiLeft() + 144 + 11, container.getGuiTop() + 26, 8);
                }
            }
        });
        return pieces;
    }

    public float performWork() {
        ItemStack ingredient;
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (this.action > 5) {
            this.action = 0;
        }
        if (this.action != 0 && this.outputPotions.getStackInSlot(0).func_190926_b() && this.outputPotions.getStackInSlot(1).func_190926_b() && this.outputPotions.getStackInSlot(2).func_190926_b()) {
            this.action = 0;
            return 1.0f;
        }
        if (this.action == 0 && this.inputGlassBottles.getStackInSlot(0).func_190916_E() >= 3 && ItemHandlerHelper.insertItem((IItemHandler)this.outputPotions, (ItemStack)new ItemStack((Item)Items.field_151068_bn, 3), (boolean)true).func_190926_b() && this.fluidTank.getFluidAmount() >= 3000) {
            ItemStack bottles = new ItemStack((Item)Items.field_151068_bn, 3);
            bottles.func_77982_d(new PotionItems().func_188217_a(bottles.func_77978_p() == null ? new NBTTagCompound() : bottles.func_77978_p()));
            ItemHandlerHelper.insertItem((IItemHandler)this.outputPotions, (ItemStack)bottles, (boolean)false);
            this.fluidTank.drain(3000, true);
            this.inputGlassBottles.getStackInSlot(0).func_190920_e(this.inputGlassBottles.getStackInSlot(0).func_190916_E() - 3);
            this.action = 1;
            return 1.0f;
        }
        if (this.action > 0 && !(ingredient = this.inputIngredients.getStackInSlot(this.action - 1)).func_190926_b()) {
            NonNullList potions = NonNullList.func_191196_a();
            potions.add((Object)this.outputPotions.getStackInSlot(0));
            potions.add((Object)this.outputPotions.getStackInSlot(1));
            potions.add((Object)this.outputPotions.getStackInSlot(2));
            if (BrewingRecipeRegistry.hasOutput((ItemStack)((ItemStack)potions.get(0)), (ItemStack)ingredient)) {
                BrewingRecipeRegistry.brewPotions((NonNullList)potions, (ItemStack)ingredient, (int[])new int[]{0, 1, 2});
                for (int i = 0; i < 3; ++i) {
                    this.outputPotions.setStackInSlot(i, (ItemStack)potions.get(i));
                }
                ++this.action;
                ingredient.func_190920_e(ingredient.func_190916_E() - 1);
                if (this.action > 5) {
                    this.action = 0;
                }
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_ACTION, this.action);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.action = !compound.func_74764_b(NBT_ACTION) ? 0 : compound.func_74762_e(NBT_ACTION);
    }

    public IFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ItemStackHandler getOutputPotions() {
        return this.outputPotions;
    }
}

