/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.mob;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.block.MobRelocatorBlock;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class MobRelocatorTile
extends WorkingAreaElectricMachine {
    private IFluidTank outExp;
    private ItemStackHandler outItems;

    public MobRelocatorTile() {
        super(MobRelocatorTile.class.getName().hashCode(), 2, 1, false);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outExp = this.addFluidTank(FluidsRegistry.ESSENCE, 8000, EnumDyeColor.LIME, "Experience tank", new BoundingRectangle(50, 25, 18, 54));
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                MobRelocatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Mob drops", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "mob_relocator_out");
    }

    public void protectedUpdate() {
        super.protectedUpdate();
        this.func_145831_w().func_72872_a(EntityXPOrb.class, this.getWorkingArea().func_72314_b(2.0, 2.0, 2.0)).forEach(Entity::func_70106_y);
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        AxisAlignedBB area = this.getWorkingArea();
        List mobs = this.func_145831_w().func_72872_a(EntityLiving.class, area);
        if (mobs.size() == 0) {
            return 0.0f;
        }
        EntityLiving mob = (EntityLiving)mobs.get(this.func_145831_w().field_73012_v.nextInt(mobs.size()));
        this.outExp.fill(new FluidStack((Fluid)FluidsRegistry.ESSENCE, (int)(mob.func_110143_aJ() * ((MobRelocatorBlock)this.func_145838_q()).getEssenceMultiplier())), true);
        mob.func_70097_a(DamageSource.func_76365_a((EntityPlayer)IndustrialForegoing.getFakePlayer(this.field_145850_b)), mob.func_110138_aP());
        List items = this.func_145831_w().func_72872_a(EntityItem.class, area);
        for (EntityItem item : items) {
            if (item.func_92059_d().func_190926_b()) continue;
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)item.func_92059_d(), (boolean)false);
            item.func_70106_y();
        }
        return 1.0f;
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        EnumFacing f = this.getFacing().func_176734_d();
        BlockPos corner1 = new BlockPos(0, 0, 0).func_177967_a(f, this.getRadius() + 1).func_177967_a(EnumFacing.UP, this.getHeight());
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b((double)this.getRadius(), (double)this.getHeight(), (double)this.getRadius()).func_186670_a(corner1);
    }
}

