/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.world;

import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlockDestroyerTile
extends WorkingAreaElectricMachine {
    private ItemStackHandler outItems;

    public BlockDestroyerTile() {
        super(BlockDestroyerTile.class.getName().hashCode(), 0, 0, true);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outItems = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                BlockDestroyerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Broken items", 54, 25, 6, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "block_destroyer_out");
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186670_a(new BlockPos(0, 0, 0).func_177972_a(this.getFacing().func_176734_d()));
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        List<BlockPos> blockPosList = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        for (BlockPos pos : blockPosList) {
            if (this.field_145850_b.func_175623_d(pos)) continue;
            Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            List drops = block.getDrops((IBlockAccess)this.field_145850_b, pos, this.field_145850_b.func_180495_p(pos), 0);
            boolean canInsert = true;
            for (ItemStack stack : drops) {
                if (ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                canInsert = false;
                break;
            }
            if (!canInsert) continue;
            for (ItemStack stack : drops) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
            }
            this.field_145850_b.func_175698_g(pos);
            return 1.0f;
        }
        return 0.0f;
    }
}

