/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class AnimalStockIncreaserTile
extends WorkingAreaElectricMachine {
    public ItemStackHandler inFeedItems;

    public AnimalStockIncreaserTile() {
        super(AnimalStockIncreaserTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inFeedItems = new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                AnimalStockIncreaserTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.inFeedItems, EnumDyeColor.GREEN, "Food items", 54, 25, 6, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return true;
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.inFeedItems, "animal_stock_in");
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        AxisAlignedBB area = this.getWorkingArea();
        List animals = this.field_145850_b.func_72872_a(EntityAnimal.class, area);
        if (animals.size() == 0 || animals.size() > 35) {
            return 0.0f;
        }
        animals.removeIf(entityAnimal -> entityAnimal.func_70631_g_() || entityAnimal.func_70874_b() != 0 || this.getFirstBreedingItem((EntityAnimal)entityAnimal).func_190926_b() || entityAnimal.func_70880_s());
        for (EntityAnimal firstParent : animals) {
            for (EntityAnimal secondParent : animals) {
                if (firstParent.equals((Object)secondParent) || !firstParent.getClass().equals(secondParent.getClass())) continue;
                ItemStack stack = this.getFirstBreedingItem(firstParent);
                Item item = stack.func_77973_b();
                stack.func_190920_e(stack.func_190916_E() - 1);
                stack = this.getFirstBreedingItem(secondParent);
                if (stack.func_190926_b()) {
                    ItemHandlerHelper.insertItem((IItemHandler)this.inFeedItems, (ItemStack)new ItemStack(item, 1), (boolean)false);
                    return 0.0f;
                }
                stack.func_190920_e(stack.func_190916_E() - 1);
                firstParent.func_146082_f(null);
                secondParent.func_146082_f(null);
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public ItemStack getFirstBreedingItem(EntityAnimal animal) {
        for (int i = 0; i < this.inFeedItems.getSlots(); ++i) {
            if (animal instanceof EntityLlama && this.inFeedItems.getStackInSlot(i).func_77969_a(new ItemStack(Blocks.field_150407_cf))) {
                return this.inFeedItems.getStackInSlot(i);
            }
            if (animal instanceof EntityHorse && (this.inFeedItems.getStackInSlot(i).func_77969_a(new ItemStack(Items.field_151153_ao)) || this.inFeedItems.getStackInSlot(i).func_77969_a(new ItemStack(Items.field_151150_bK)))) {
                return this.inFeedItems.getStackInSlot(i);
            }
            if (!animal.func_70877_b(this.inFeedItems.getStackInSlot(i))) continue;
            return this.inFeedItems.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }
}

