/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.FluidTankType;

public class PlantInteractorTile
extends WorkingAreaElectricMachine {
    public static final List<PlantInteractorTile> WORKING_TILES = new ArrayList<PlantInteractorTile>();
    private static String NBT_POINTER = "pointer";
    private IFluidTank sludge;
    private ItemStackHandler outItems;
    private int pointer;
    private boolean hasWorked;

    public PlantInteractorTile() {
        super(PlantInteractorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.sludge = this.addSimpleFluidTank(8000, "Sludge Tank", EnumDyeColor.BLACK, 50, 25, FluidTankType.OUTPUT, fluidStack -> false, fluidStack -> true);
        this.outItems = (ItemStackHandler)this.addSimpleInventory(12, "output_items", EnumDyeColor.ORANGE, "output_items", new BoundingRectangle(93, 25, 72, 54), (stack, integer) -> false, (stack, integer) -> true, false, null);
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (ItemStackUtils.isInventoryFull(this.outItems)) {
            return 0.0f;
        }
        this.hasWorked = false;
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        if (this.pointer >= blockPos.size() / (BlockRegistry.plantInteractorBlock.getHeight() + 1)) {
            this.pointer = 0;
        }
        if (this.pointer < blockPos.size() && BlockUtils.canBlockBeBroken(this.field_145850_b, blockPos.get(this.pointer))) {
            BlockPos pointerPos = blockPos.get(this.pointer);
            for (int i = 0; i < BlockRegistry.plantInteractorBlock.getHeight() + 1; ++i) {
                BlockPos tempPos = new BlockPos(pointerPos.func_177958_n(), pointerPos.func_177956_o() + i, pointerPos.func_177952_p());
                IBlockState tempState = this.field_145850_b.func_180495_p(tempPos);
                if (!(tempState.func_177230_c() instanceof IPlantable) && !(tempState.func_177230_c() instanceof IGrowable)) continue;
                FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b, tempPos.func_177984_a());
                player.field_71071_by.func_174888_l();
                WORKING_TILES.add(this);
                tempState.func_177230_c().func_180639_a(this.field_145850_b, tempPos, tempState, (EntityPlayer)player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (BlockPos)tempPos, (EnumFacing)EnumFacing.UP, (Vec3d)new Vec3d(0.0, 0.0, 0.0));
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack.func_190926_b()) continue;
                    ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
                    this.sludge.fill(new FluidStack((Fluid)FluidsRegistry.SLUDGE, 10 * stack.func_190916_E()), true);
                    this.hasWorked = true;
                }
                player.field_71071_by.func_174888_l();
                WORKING_TILES.remove(this);
            }
        }
        ++this.pointer;
        return this.hasWorked ? 1.0f : 0.1f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = compound.func_74762_e(NBT_POINTER);
    }

    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        for (ItemStack stack : event.getDrops()) {
            ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)stack, (boolean)false);
            this.sludge.fill(new FluidStack((Fluid)FluidsRegistry.SLUDGE, 10 * stack.func_190916_E()), true);
        }
        event.getDrops().clear();
        this.hasWorked = true;
    }
}

