/*
 * Decompiled with CFR 0.152.
 */
package paulevs.infgen.generator;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2906;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3098;
import net.minecraft.class_3145;
import net.minecraft.class_3195;
import net.minecraft.class_3211;
import paulevs.infgen.generator.SurfaceBiomes;

public class InfWorldChunkGeneratorConfig
extends class_2906 {
    private boolean onlyInfdev;
    private int biomeSize;
    private boolean hasVillages;
    private boolean hasDungeons;
    private boolean hasMineshafts;
    private boolean hasOtherStructures;
    private boolean hasBedrock;
    private boolean carveCaves;
    private Set<class_1959> biomes;

    public int method_12614() {
        return this.biomeSize;
    }

    public int method_12616() {
        return -1;
    }

    @Environment(value=EnvType.CLIENT)
    public Dynamic<?> toDynamic(class_2509 dynamicOps) {
        HashMap<class_2520, class_2520> map = new HashMap<class_2520, class_2520>();
        map.put(dynamicOps.method_10639("only_infdev_biome"), dynamicOps.method_23253(false));
        map.put(dynamicOps.method_10639("biome_size"), dynamicOps.method_10661(3));
        map.put(dynamicOps.method_10639("has_villages"), dynamicOps.method_23253(true));
        map.put(dynamicOps.method_10639("has_dungeons"), dynamicOps.method_23253(true));
        map.put(dynamicOps.method_10639("has_mineshafts"), dynamicOps.method_23253(true));
        map.put(dynamicOps.method_10639("has_other_structures"), dynamicOps.method_23253(true));
        map.put(dynamicOps.method_10639("has_bedrock"), dynamicOps.method_23253(true));
        map.put(dynamicOps.method_10639("carve_caves"), dynamicOps.method_23253(true));
        map.put(dynamicOps.method_10639("biomes"), dynamicOps.method_10657(this.getDefaultBiomes()));
        return new Dynamic((DynamicOps)dynamicOps, (Object)dynamicOps.method_10655(map));
    }

    public static InfWorldChunkGeneratorConfig fromDynamic(Dynamic dynamic) {
        InfWorldChunkGeneratorConfig config = new InfWorldChunkGeneratorConfig();
        config.onlyInfdev = dynamic.get("only_infdev_biome").asBoolean(false);
        config.biomeSize = dynamic.get("biome_size").asInt(3);
        config.hasVillages = dynamic.get("has_villages").asBoolean(true);
        config.hasDungeons = dynamic.get("has_dungeons").asBoolean(true);
        config.hasMineshafts = dynamic.get("has_mineshafts").asBoolean(true);
        config.hasOtherStructures = dynamic.get("has_other_structures").asBoolean(true);
        config.hasBedrock = dynamic.get("has_bedrock").asBoolean(true);
        config.carveCaves = dynamic.get("carve_caves").asBoolean(true);
        config.biomes = InfWorldChunkGeneratorConfig.parceBiomes(dynamic.get("biomes").asByteBuffer());
        return config;
    }

    public boolean onlyInfdev() {
        return this.onlyInfdev;
    }

    public boolean hasStructure(class_3195<? extends class_3037> structureFeature) {
        if (structureFeature instanceof class_3211) {
            return this.hasVillages;
        }
        if (structureFeature instanceof class_3098) {
            return this.hasMineshafts;
        }
        if (structureFeature instanceof class_3145) {
            return this.hasDungeons;
        }
        return this.hasOtherStructures;
    }

    public boolean carveCaves() {
        return this.carveCaves;
    }

    public boolean hasBedrock() {
        return this.hasBedrock;
    }

    public Set<class_1959> getBiomes() {
        return this.biomes;
    }

    private ByteBuffer getDefaultBiomes() {
        String biomes = "";
        for (class_1959 biome : SurfaceBiomes.BIOMES) {
            String name = class_2378.field_11153.method_10221((Object)biome).toString();
            biomes = biomes + (biomes.isEmpty() ? name : ";" + name);
        }
        return ByteBuffer.wrap(biomes.getBytes());
    }

    private static Set<class_1959> parceBiomes(ByteBuffer buffer) {
        String[] biomes;
        HashSet<class_1959> result = new HashSet<class_1959>();
        String biomesAll = new String(buffer.array());
        for (String biome : biomes = biomesAll.split(";")) {
            class_2960 id = new class_2960(biome);
            if (!class_2378.field_11153.method_10250(id)) continue;
            result.add((class_1959)class_2378.field_11153.method_10223(id));
        }
        if (result.isEmpty()) {
            result.addAll(SurfaceBiomes.BIOMES);
        }
        return result;
    }
}

