/*
 * Decompiled with CFR 0.152.
 */
package paulevs.infgen.generator.port;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3642;
import paulevs.infgen.IBiomeArray;
import paulevs.infgen.generator.port.Ore;
import paulevs.infgen.generator.port.Tree;
import paulevs.infgen.generator.port.ValueNoiseOctaved;

public class InfGenPort {
    private static final Random RANDOM = new Random();
    private static final long RND_X = 341873128712L;
    private static final long RND_Z = 132897987541L;
    private static final byte ID_AIR = 0;
    private static final byte ID_GRASS = 2;
    private static final byte ID_DIRT = 3;
    private static final byte ID_WATER = 9;
    private static final byte ID_STONE = 1;
    private static final byte ID_GRAVEL = 13;
    private static final byte ID_SAND = 12;
    private ValueNoiseOctaved noiseA;
    private ValueNoiseOctaved noiseB;
    private ValueNoiseOctaved noiseC;
    private ValueNoiseOctaved noiseSand;
    private ValueNoiseOctaved noiseHeightmap;
    private ValueNoiseOctaved noiseTrees;
    private static final class_2338.class_2339 BIOME_POS = new class_2338.class_2339();
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private static final class_2680 STONE = class_2246.field_10340.method_9564();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2680 GRAVEL = class_2246.field_10255.method_9564();
    private static final class_2680 SAND = class_2246.field_10102.method_9564();
    private static final byte[] BLOCKS = new byte[32768];
    private static final double[][] NOISE = new double[33][4];
    private int lastX = Integer.MAX_VALUE;
    private int lastZ = Integer.MAX_VALUE;
    private static final Ore ORE_COAL = new Ore(class_2246.field_10418.method_9564());
    private static final Ore ORE_IRON = new Ore(class_2246.field_10212.method_9564());
    private static final Ore ORE_GOLD = new Ore(class_2246.field_10571.method_9564());
    private static final Ore ORE_DIAMOND = new Ore(class_2246.field_10442.method_9564());
    private static final Tree TREE = new Tree();

    public InfGenPort(long paramLong) {
        RANDOM.setSeed(paramLong);
        this.noiseA = new ValueNoiseOctaved(RANDOM, 16);
        this.noiseB = new ValueNoiseOctaved(RANDOM, 16);
        this.noiseC = new ValueNoiseOctaved(RANDOM, 8);
        this.noiseSand = new ValueNoiseOctaved(RANDOM, 4);
        this.noiseHeightmap = new ValueNoiseOctaved(RANDOM, 4);
        new ValueNoiseOctaved(RANDOM, 5);
        this.noiseTrees = new ValueNoiseOctaved(RANDOM, 5);
    }

    public void makeChunk(int chunkX, int chunkZ, class_2791 chunk, class_3642 oceanBiomes, class_1936 world) {
        if (!this.isCached(chunkX, chunkZ)) {
            this.fillArray(chunkX, chunkZ);
        }
        for (int x = 0; x < 16; ++x) {
            POS.method_20787(x);
            BIOME_POS.method_20787(x + (chunkX << 4));
            for (int z = 0; z < 16; ++z) {
                POS.method_20788(z);
                BIOME_POS.method_20788(z + (chunkZ << 4));
                class_1959 biome = world.method_23753((class_2338)BIOME_POS);
                int index = x << 11 | z << 7 | 0x7F;
                for (int y = 127; y >= 0; --y) {
                    POS.method_10099(y);
                    byte id = BLOCKS[index];
                    if (id == 1) {
                        chunk.method_12010((class_2338)POS, STONE, false);
                    } else if (id == 3) {
                        chunk.method_12010((class_2338)POS, biome.method_8722().method_15336(), false);
                    } else if (id == 2) {
                        chunk.method_12010((class_2338)POS, biome.method_8722().method_15337(), false);
                    } else if (id == 12) {
                        chunk.method_12010((class_2338)POS, SAND, false);
                    } else if (id == 13) {
                        chunk.method_12010((class_2338)POS, GRAVEL, false);
                    } else if (id == 9) {
                        chunk.method_12010((class_2338)POS, WATER, false);
                    }
                    --index;
                }
            }
        }
        if (oceanBiomes != null) {
            IBiomeArray array = (IBiomeArray)chunk.method_12036();
            for (int x = 0; x < 4; ++x) {
                int px = x << 2 | 2;
                int wx = x | chunkX << 2;
                for (int z = 0; z < 4; ++z) {
                    int pz = z << 2 | 2;
                    int wz = z | chunkZ << 2;
                    int h = this.getSolidHeight(px, pz);
                    if (h >= 63) continue;
                    array.setBiome(x, z, oceanBiomes.method_16341(wx, wz));
                }
            }
        }
    }

    public void fillArray(int chunkX, int chunkZ) {
        int x;
        this.lastX = chunkX;
        this.lastZ = chunkZ;
        RANDOM.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (x = 0; x < 4; ++x) {
            int px = chunkX << 2 | x;
            for (int z = 0; z < 4; ++z) {
                int py;
                int pz = chunkZ << 2 | z;
                int iz = z << 2 << 7;
                for (py = 0; py < NOISE.length; ++py) {
                    InfGenPort.NOISE[py][0] = this.getNoise(px, py, pz);
                    InfGenPort.NOISE[py][1] = this.getNoise(px, py, pz + 1);
                    InfGenPort.NOISE[py][2] = this.getNoise(px + 1, py, pz);
                    InfGenPort.NOISE[py][3] = this.getNoise(px + 1, py, pz + 1);
                }
                for (py = 0; py < 32; ++py) {
                    double n1 = NOISE[py][0];
                    double n2 = NOISE[py][1];
                    double n3 = NOISE[py][2];
                    double n4 = NOISE[py][3];
                    double n5 = NOISE[py + 1][0];
                    double n7 = NOISE[py + 1][1];
                    double n8 = NOISE[py + 1][2];
                    double n9 = NOISE[py + 1][3];
                    for (int by = 0; by < 4; ++by) {
                        double mixY = (double)by / 4.0;
                        double nx1 = n1 + (n5 - n1) * mixY;
                        double nx2 = n2 + (n7 - n2) * mixY;
                        double nx3 = n3 + (n8 - n3) * mixY;
                        double nx4 = n4 + (n9 - n4) * mixY;
                        int iy = py << 2 | by;
                        for (int bx = 0; bx < 4; ++bx) {
                            int ix = (x << 2 | bx) << 11;
                            double mixX = (double)bx / 4.0;
                            double nz1 = nx1 + (nx3 - nx1) * mixX;
                            double nz2 = nx2 + (nx4 - nx2) * mixX;
                            int index = ix | iy | iz;
                            for (int bz = 0; bz < 4; ++bz) {
                                double mixZ = (double)bz / 4.0;
                                double noiseValue = nz1 + (nz2 - nz1) * mixZ;
                                int blockID = 0;
                                if ((py << 2) + by < 64) {
                                    blockID = 9;
                                }
                                if (noiseValue > 0.0) {
                                    blockID = 1;
                                }
                                InfGenPort.BLOCKS[index] = blockID;
                                index += 128;
                            }
                        }
                    }
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d1 = (chunkX << 4) + x;
                double n1 = (chunkZ << 4) + z;
                boolean sandNoise = this.noiseSand.eval(d1 * 0.03125, n1 * 0.03125, 0.0) + RANDOM.nextDouble() * 0.2 > 0.0;
                boolean gravelNoise = this.noiseSand.eval(n1 * 0.03125, 109.0134, d1 * 0.03125) + RANDOM.nextDouble() * 0.2 > 3.0;
                int height = (int)(this.noiseHeightmap.eval(d1 * 0.0625, n1 * 0.0625) / 3.0 + 3.0 + RANDOM.nextDouble() * 0.25);
                int index = x << 11 | z << 7 | 0x7F;
                int checker = -1;
                int blockID1 = 2;
                int blockID2 = 3;
                for (int y = 127; y >= 0; --y) {
                    if (BLOCKS[index] == 0) {
                        checker = -1;
                    } else if (BLOCKS[index] == 1) {
                        if (checker == -1) {
                            if (height <= 0) {
                                blockID1 = 0;
                                blockID2 = 1;
                            } else if (y >= 60 && y <= 65) {
                                blockID1 = 2;
                                blockID2 = 3;
                                if (gravelNoise) {
                                    blockID1 = 0;
                                    blockID2 = 13;
                                }
                                if (sandNoise) {
                                    blockID1 = 12;
                                    blockID2 = 12;
                                }
                            }
                            if (y < 64 && blockID1 == 0) {
                                blockID1 = 9;
                            }
                            checker = height;
                            InfGenPort.BLOCKS[index] = y >= 63 ? (byte)blockID1 : (byte)blockID2;
                        } else if (checker > 0) {
                            --checker;
                            InfGenPort.BLOCKS[index] = (byte)blockID2;
                        }
                    }
                    --index;
                }
            }
        }
    }

    private double getNoise(double x, double y, double z) {
        double res;
        double d;
        double d2;
        double elevGrad = y * 4.0 - 64.0;
        if (d2 < 0.0) {
            elevGrad *= 3.0;
        }
        double noise = this.noiseC.eval(x * 8.55515, y * 1.71103, z * 8.55515) / 2.0;
        if (d < -1.0) {
            res = this.clamp(this.noiseA.eval(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad, -10.0, 10.0);
        } else if (noise > 1.0) {
            res = this.clamp(this.noiseB.eval(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad, -10.0, 10.0);
        } else {
            double noise2 = this.clamp(this.noiseA.eval(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad, -10.0, 10.0);
            double noise3 = this.clamp(this.noiseB.eval(x * 684.412, y * 984.412, z * 684.412) / 512.0 - elevGrad, -10.0, 10.0);
            double mix = (noise + 1.0) / 2.0;
            res = noise2 + (noise3 - noise2) * mix;
        }
        return res;
    }

    private double clamp(double x, double min, double max) {
        return x < min ? min : (x > max ? max : x);
    }

    public int getHeight(int px, int pz) {
        int chunkX = px >> 4;
        int chunkZ = pz >> 4;
        if (this.isCached(chunkX, chunkZ)) {
            return this.getArrayHeight(px & 0xF, pz & 0xF);
        }
        this.fillArray(chunkX, chunkZ);
        return this.getArrayHeight(px & 0xF, pz & 0xF);
    }

    private boolean isCached(int cx, int cz) {
        return this.lastX == cx && this.lastZ == cz;
    }

    private int getArrayHeight(int x, int z) {
        int index = x << 11 | z << 7 | 0x7F;
        for (int y = 127; y >= 0; --y) {
            if (BLOCKS[index] != 0) {
                return y;
            }
            --index;
        }
        return 0;
    }

    private int getSolidHeight(int x, int z) {
        int index = x << 11 | z << 7 | 0x7F;
        for (int y = 127; y >= 0; --y) {
            if (BLOCKS[index] != 0 && BLOCKS[index] != 9) {
                return y;
            }
            --index;
        }
        return 0;
    }

    public void populate(class_1936 world, class_2791 chunk) {
        int z;
        int y;
        int x;
        int i;
        int posX = chunk.method_12004().field_9181;
        int posZ = chunk.method_12004().field_9180;
        RANDOM.setSeed((long)posX * 318279123L + (long)posZ * 919871212L);
        posX <<= 4;
        posZ <<= 4;
        for (i = 0; i < 20; ++i) {
            int x2 = posX + RANDOM.nextInt(16);
            int y2 = RANDOM.nextInt(128);
            int z2 = posZ + RANDOM.nextInt(16);
            ORE_COAL.generate(world, RANDOM, x2, y2, z2);
        }
        for (i = 0; i < 10; ++i) {
            int var15 = posX + RANDOM.nextInt(16);
            int var19 = RANDOM.nextInt(64);
            int var23 = posZ + RANDOM.nextInt(16);
            ORE_IRON.generate(world, RANDOM, var15, var19, var23);
        }
        if (RANDOM.nextInt(2) == 0) {
            x = posX + RANDOM.nextInt(16);
            y = RANDOM.nextInt(32);
            z = posZ + RANDOM.nextInt(16);
            ORE_GOLD.generate(world, RANDOM, x, y, z);
        }
        if (RANDOM.nextInt(8) == 0) {
            x = posX + RANDOM.nextInt(16);
            y = RANDOM.nextInt(16);
            z = posZ + RANDOM.nextInt(16);
            ORE_DIAMOND.generate(world, RANDOM, x, y, z);
        }
        int count = (int)this.noiseTrees.eval((double)posX * 0.25, (double)posZ * 0.25) << 3;
        TREE.chunkReset();
        for (int i2 = 0; i2 < count; ++i2) {
            int px = posX + RANDOM.nextInt(16) + 8;
            int pz = posZ + RANDOM.nextInt(16) + 8;
            int py = this.getHeight(px, pz, world);
            TREE.generate(world, RANDOM, px, py, pz);
        }
    }

    private int getHeight(int x, int z, class_1936 world) {
        class_2791 chunk = world.method_8392(x >> 4, z >> 4);
        return chunk.method_12032(class_2902.class_2903.field_13202).method_12603(x &= 0xF, z &= 0xF);
    }
}

