/*
 * Decompiled with CFR 0.152.
 */
package paulevs.infgen.generator.port;

import java.util.Random;

public final class ValueNoise {
    private int[] values = new int[512];
    private double offsetX;
    private double offsetY;
    private double offsetZ;

    public ValueNoise() {
        this(new Random());
    }

    public ValueNoise(Random random) {
        this.offsetX = random.nextDouble() * 256.0;
        this.offsetY = random.nextDouble() * 256.0;
        this.offsetZ = random.nextDouble() * 256.0;
        int i = 0;
        while (i < 256) {
            this.values[i] = i++;
        }
        for (i = 0; i < 256; ++i) {
            int index = random.nextInt(256 - i) + i;
            int value = this.values[i];
            this.values[i] = this.values[index];
            this.values[index] = value;
            this.values[i + 256] = this.values[i];
        }
    }

    private double interpolate(double x, double y, double z) {
        double posX = x + this.offsetX;
        double posY = y + this.offsetY;
        double posZ = z + this.offsetZ;
        int ix = ValueNoise.floor(posX) & 0xFF;
        int iy = ValueNoise.floor(posY) & 0xFF;
        int iz = ValueNoise.floor(posZ) & 0xFF;
        posX -= (double)ValueNoise.floor(posX);
        posY -= (double)ValueNoise.floor(posY);
        posZ -= (double)ValueNoise.floor(posZ);
        double mixX = ValueNoise.sigmoid(posX);
        double mixY = ValueNoise.sigmoid(posY);
        double mixZ = ValueNoise.sigmoid(posZ);
        int valX = this.values[ix] + iy;
        int valZ = this.values[valX] + iz;
        valX = this.values[valX + 1] + iz;
        ix = this.values[ix + 1] + iy;
        iy = this.values[ix] + iz;
        ix = this.values[ix + 1] + iz;
        return ValueNoise.lerp(mixZ, ValueNoise.lerp(mixY, ValueNoise.lerp(mixX, ValueNoise.a(this.values[valZ], posX, posY, posZ), ValueNoise.a(this.values[iy], posX - 1.0, posY, posZ)), ValueNoise.lerp(mixX, ValueNoise.a(this.values[valX], posX, posY - 1.0, posZ), ValueNoise.a(this.values[ix], posX - 1.0, posY - 1.0, posZ))), ValueNoise.lerp(mixY, ValueNoise.lerp(mixX, ValueNoise.a(this.values[valZ + 1], posX, posY, posZ - 1.0), ValueNoise.a(this.values[iy + 1], posX - 1.0, posY, posZ - 1.0)), ValueNoise.lerp(mixX, ValueNoise.a(this.values[valX + 1], posX, posY - 1.0, posZ - 1.0), ValueNoise.a(this.values[ix + 1], posX - 1.0, posY - 1.0, posZ - 1.0))));
    }

    private static double sigmoid(double x) {
        return x * x * x * (x * (x * 6.0 - 15.0) + 10.0);
    }

    private static double lerp(double mix, double a, double b) {
        return a + mix * (b - a);
    }

    private static double a(int var0, double var1, double var3, double var5) {
        double var8;
        int var12 = var0 & 0xF;
        double d = var8 = var12 < 8 ? var1 : var3;
        double var10 = var12 < 4 ? var3 : (var12 != 12 && var12 != 14 ? var5 : var1);
        return ((var12 & 1) == 0 ? var8 : -var8) + ((var12 & 2) == 0 ? var10 : -var10);
    }

    public final double eval(double x, double y) {
        return this.interpolate(x, y, 0.0);
    }

    public final double eval(double x, double y, double z) {
        return this.interpolate(x, y, z);
    }

    public static int floor(double x) {
        int ix = (int)x;
        if (x < (double)ix) {
            return ix - 1;
        }
        return ix;
    }
}

