/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.data.ConfigEnabledCondition;
import knightminer.inspirations.common.data.FillTexturedBlockLootFunction;
import knightminer.inspirations.common.data.PulseLoadedCondition;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.ModItemList;
import knightminer.inspirations.library.recipe.ShapelessNoContainerRecipe;
import knightminer.inspirations.library.recipe.TextureRecipe;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.config.IConfiguration;
import slimeknights.mantle.pulsar.control.PulseManager;

@Mod(value="inspirations")
public class Inspirations {
    public static final String modID = "inspirations";
    public static final Logger log = LogManager.getLogger((String)"inspirations");
    public static PulseManager pulseManager;
    public static boolean configLoaded;

    public Inspirations() {
        pulseManager = new PulseManager((IConfiguration)Config.pulseConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SPEC);
        log.info("Loading replacements config file...");
        CommentedFileConfig repl_config = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("inspirations-replacements.toml")).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        repl_config.load();
        repl_config.save();
        Config.SPEC_OVERRIDE.setConfig((CommentedConfig)repl_config);
        log.info("Config loaded.");
        MinecraftForge.EVENT_BUS.register((Object)pulseManager);
        MinecraftForge.EVENT_BUS.addListener(this::registerRecipeTypes);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        pulseManager.registerPulse((Object)new InspirationsShared());
        pulseManager.registerPulse((Object)new InspirationsBuilding());
        pulseManager.registerPulse((Object)new InspirationsUtility());
        pulseManager.registerPulse((Object)new InspirationsTools());
        pulseManager.registerPulse((Object)new InspirationsTweaks());
        pulseManager.enablePulses();
        InspirationsNetwork.instance.setup();
    }

    @SubscribeEvent
    public void configChanged(ModConfig.ModConfigEvent configEvent) {
        configLoaded = true;
        InspirationsRegistry.setBookKeywords(Arrays.stream(((String)Config.bookKeywords.get()).split(",")).map(String::trim).collect(Collectors.toList()));
        InspirationsRegistry.setDefaultEnchantingPower(((Double)Config.defaultEnchantingPower.get()).floatValue());
    }

    @SubscribeEvent
    public void registerRecipeTypes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry r = event.getRegistry();
        r.register(ShapelessNoContainerRecipe.SERIALIZER);
        r.register(TextureRecipe.SERIALIZER);
    }

    @SubscribeEvent
    public void registerMisc(FMLCommonSetupEvent event) {
        PulseLoadedCondition.Serializer pulseLoaded = new PulseLoadedCondition.Serializer();
        ConfigEnabledCondition.Serializer confEnabled = new ConfigEnabledCondition.Serializer();
        CraftingHelper.register((IConditionSerializer)pulseLoaded);
        CraftingHelper.register((IConditionSerializer)confEnabled);
        CraftingHelper.register((ResourceLocation)Util.getResource("mod_item_list"), (IIngredientSerializer)ModItemList.SERIALIZER);
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)pulseLoaded);
        LootConditionManager.func_186639_a((ILootCondition.AbstractSerializer)confEnabled);
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new FillTexturedBlockLootFunction.Serializer(Util.getResource("fill_textured_block")));
    }

    static {
        configLoaded = false;
    }
}

