/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import java.util.concurrent.CompletableFuture;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.BookshelfBlock;
import knightminer.inspirations.building.block.EnlightenedBushBlock;
import knightminer.inspirations.building.client.BookshelfModel;
import knightminer.inspirations.building.client.BookshelfScreen;
import knightminer.inspirations.building.tileentity.BookshelfTileEntity;
import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class BuildingClientProxy
extends ClientProxy {
    public static final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_219534_a((stage, resMan, prepProp, reloadProf, bgExec, gameExec) -> CompletableFuture.runAsync(() -> BookshelfModel.BOOK_CACHE.invalidateAll(), gameExec).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0)));
        } else {
            Inspirations.log.error("Failed to register resource reload listener, expected instance of IReloadableResourceManager but got {}", manager.getClass());
        }
        ScreenManager.func_216911_a(InspirationsBuilding.contBookshelf, BookshelfScreen::new);
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            ItemStack stack;
            TileEntity te;
            if (tintIndex > 0 && tintIndex <= 14 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof BookshelfTileEntity && !(stack = ((BookshelfTileEntity)te).func_70301_a(tintIndex - 1)).func_190926_b()) {
                int color = ClientUtil.getItemColor(stack.func_77973_b());
                int itemColors = mc.getItemColors().func_186728_a(stack, 0);
                if (itemColors > -1) {
                    color = Util.combineColors(color, itemColors, 3);
                }
                return color;
            }
            return -1;
        }, new Block[]{InspirationsBuilding.shelf_normal});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (world != null && pos != null) {
                return BiomeColors.func_217615_b((IEnviromentBlockReader)world, (BlockPos)pos);
            }
            return FoliageColors.func_77468_c();
        }, new Block[]{InspirationsBuilding.vine});
        for (EnlightenedBushBlock bush : new EnlightenedBushBlock[]{InspirationsBuilding.redEnlightenedBush, InspirationsBuilding.blueEnlightenedBush, InspirationsBuilding.greenEnlightenedBush}) {
            int color = bush.getColor();
            blockColors.func_186722_a((state, world, pos, tintIndex) -> tintIndex == 0 ? color : -1, new Block[]{bush});
        }
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            Block block;
            if (tintIndex != 0 || world == null || pos == null) {
                return -1;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te != null && (block = TextureBlockUtil.getTextureBlock(te)) != Blocks.field_150350_a) {
                return ClientUtil.getStackBlockColorsSafe(new ItemStack((IItemProvider)block), world, pos, 0);
            }
            return FoliageColors.func_77468_c();
        }, new Block[]{InspirationsBuilding.whiteEnlightenedBush});
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, tintIndex) -> {
            if (tintIndex > 0 && tintIndex <= 14) {
                return 6638359;
            }
            return -1;
        }, new IItemProvider[]{InspirationsBuilding.shelf_normal});
        for (DyeColor dyeColor : DyeColor.values()) {
            int hexColor = dyeColor.field_193351_w;
            itemColors.func_199877_a((stack, tintIndex) -> tintIndex == 0 ? hexColor : -1, new IItemProvider[]{InspirationsBuilding.coloredBooks[dyeColor.func_196059_a()]});
        }
        for (EnlightenedBushBlock enlightenedBushBlock : new EnlightenedBushBlock[]{InspirationsBuilding.redEnlightenedBush, InspirationsBuilding.blueEnlightenedBush, InspirationsBuilding.greenEnlightenedBush}) {
            int color = enlightenedBushBlock.getColor();
            itemColors.func_199877_a((stack, tintIndex) -> tintIndex == 0 ? color : -1, new IItemProvider[]{enlightenedBushBlock});
        }
        BuildingClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            Block block = TextureBlockUtil.getTextureBlock(stack);
            if (block != Blocks.field_150350_a) {
                return itemColors.func_186728_a(new ItemStack((IItemProvider)block), 0);
            }
            return FoliageColors.func_77468_c();
        }, InspirationsBuilding.whiteEnlightenedBush);
        BuildingClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> FoliageColors.func_77468_c(), InspirationsBuilding.vine);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        BuildingClientProxy.replaceBookshelfModel(event, InspirationsBuilding.shelf_normal);
        BuildingClientProxy.replaceBookshelfModel(event, InspirationsBuilding.shelf_ancient);
        BuildingClientProxy.replaceBookshelfModel(event, InspirationsBuilding.shelf_rainbow);
        BuildingClientProxy.replaceBookshelfModel(event, InspirationsBuilding.shelf_tomes);
        BuildingClientProxy.replaceBothTexturedModels(event, InspirationsBuilding.whiteEnlightenedBush.getRegistryName(), "leaves");
        BuildingClientProxy.replaceBothTexturedModels(event, InspirationsBuilding.redEnlightenedBush.getRegistryName(), "leaves");
        BuildingClientProxy.replaceBothTexturedModels(event, InspirationsBuilding.blueEnlightenedBush.getRegistryName(), "leaves");
        BuildingClientProxy.replaceBothTexturedModels(event, InspirationsBuilding.greenEnlightenedBush.getRegistryName(), "leaves");
    }

    private static void replaceBookshelfModel(ModelBakeEvent event, BookshelfBlock shelf) {
        if (shelf.getRegistryName() == null) {
            throw new AssertionError((Object)"Null registry name");
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            ModelResourceLocation location = new ModelResourceLocation(shelf.getRegistryName(), String.format("facing=%s", facing.func_176610_l()));
            BuildingClientProxy.replaceModel(event, location, BookshelfModel::new);
        }
        BuildingClientProxy.replaceTexturedModel(event, new ModelResourceLocation(shelf.getRegistryName(), "inventory"), "texture", true);
    }
}

