/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.common.Config;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class BuildingEvents {
    @SubscribeEvent
    public static void toggleRopeLadder(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!Config.enableRopeLadder() || event.getWorld().func_201670_d()) {
            return;
        }
        World world = event.getWorld();
        BlockState state = world.func_180495_p(pos = event.getPos());
        if (!(state.func_177230_c() instanceof RopeBlock)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (state.func_177229_b(RopeBlock.RUNGS) != RopeBlock.Rungs.NONE) {
            if (BuildingEvents.removeRopeLadder(world, pos, state, player)) {
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
            return;
        }
        if (BuildingEvents.makeRopeLadder(world, pos, state, event.getFace(), player, event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    private static boolean removeRopeLadder(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_70093_af()) {
            return false;
        }
        world.func_175656_a(pos, (BlockState)state.func_206870_a(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.NONE)));
        RopeBlock rope = (RopeBlock)state.func_177230_c();
        SoundType soundtype = rope.getSoundType(state, (IWorldReader)world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)rope.getRungsItem(), 4), (int)player.field_71071_by.field_70461_c);
        player.func_184602_cy();
        return true;
    }

    private static boolean makeRopeLadder(World world, BlockPos pos, BlockState state, Direction side, PlayerEntity player, ItemStack stack) {
        if (side.func_176740_k() == Direction.Axis.Y || stack.func_190916_E() < 4 && !player.func_184812_l_()) {
            return false;
        }
        RopeBlock rope = (RopeBlock)state.func_177230_c();
        if (stack.func_77973_b() != rope.getRungsItem()) {
            return false;
        }
        world.func_175656_a(pos, (BlockState)state.func_206870_a(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.fromAxis(side.func_176746_e().func_176740_k()))));
        SoundType soundtype = state.func_177230_c().getSoundType(state, (IWorldReader)world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(4);
        }
        return true;
    }
}

