/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import knightminer.inspirations.building.BuildingClientProxy;
import knightminer.inspirations.building.BuildingEvents;
import knightminer.inspirations.building.block.BookshelfBlock;
import knightminer.inspirations.building.block.ChainBlock;
import knightminer.inspirations.building.block.ClimbablePaneBlock;
import knightminer.inspirations.building.block.EnlightenedBushBlock;
import knightminer.inspirations.building.block.FlowerBlock;
import knightminer.inspirations.building.block.GlassDoorBlock;
import knightminer.inspirations.building.block.GlassTrapdoorBlock;
import knightminer.inspirations.building.block.MulchBlock;
import knightminer.inspirations.building.block.PathBlock;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.building.inventory.BookshelfContainer;
import knightminer.inspirations.building.item.GlassDoorBlockItem;
import knightminer.inspirations.building.tileentity.BookshelfTileEntity;
import knightminer.inspirations.building.tileentity.EnlightenedBushTileEntity;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.common.item.TextureBlockItem;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsBuilding", description="A collection of features to improve building")
public class InspirationsBuilding
extends PulseBase {
    public static final String pulseID = "InspirationsBuilding";
    public static Object proxy = DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> new BuildingClientProxy());
    public static BookshelfBlock shelf_normal;
    public static BookshelfBlock shelf_rainbow;
    public static BookshelfBlock shelf_tomes;
    public static BookshelfBlock shelf_ancient;
    public static RopeBlock rope;
    public static RopeBlock vine;
    public static RopeBlock chain;
    public static Block ironBars;
    public static Block glassDoor;
    public static Block glassTrapdoor;
    public static Block plainMulch;
    public static Block brownMulch;
    public static Block redMulch;
    public static Block blackMulch;
    public static Block blueMulch;
    public static PathBlock path_rock;
    public static PathBlock path_round;
    public static PathBlock path_tile;
    public static PathBlock path_brick;
    public static FlowerBlock flower_cyan;
    public static FlowerBlock flower_syringa;
    public static FlowerBlock flower_paeonia;
    public static FlowerBlock flower_rose;
    public static EnlightenedBushBlock whiteEnlightenedBush;
    public static EnlightenedBushBlock redEnlightenedBush;
    public static EnlightenedBushBlock greenEnlightenedBush;
    public static EnlightenedBushBlock blueEnlightenedBush;
    public static Item glassDoorItem;
    public static Item[] coloredBooks;
    public static Item redstoneBook;
    public static TileEntityType<BookshelfTileEntity> tileBookshelf;
    public static TileEntityType<EnlightenedBushTileEntity> tileEnlightenedBush;
    public static ContainerType<BookshelfContainer> contBookshelf;

    @SubscribeEvent
    public void registerTE(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        tileBookshelf = (TileEntityType)this.register(r, (IForgeRegistryEntry)TileEntityType.Builder.func_223042_a(BookshelfTileEntity::new, (Block[])new Block[]{shelf_normal, shelf_tomes, shelf_rainbow, shelf_ancient}).func_206865_a(null), "bookshelf");
        tileEnlightenedBush = (TileEntityType)this.register(r, (IForgeRegistryEntry)TileEntityType.Builder.func_223042_a(EnlightenedBushTileEntity::new, (Block[])new Block[]{whiteEnlightenedBush, redEnlightenedBush, greenEnlightenedBush, blueEnlightenedBush}).func_206865_a(null), "enlightened_bush");
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        contBookshelf = (ContainerType)this.register(r, (IForgeRegistryEntry)new ContainerType((ContainerType.IFactory)new BookshelfContainer.Factory()), "bookshelf");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        shelf_normal = this.registerBlock((IForgeRegistry<Block>)r, new BookshelfBlock(), "bookshelf");
        shelf_ancient = this.registerBlock((IForgeRegistry<Block>)r, new BookshelfBlock(), "ancient_bookshelf");
        shelf_rainbow = this.registerBlock((IForgeRegistry<Block>)r, new BookshelfBlock(), "rainbow_bookshelf");
        shelf_tomes = this.registerBlock((IForgeRegistry<Block>)r, new BookshelfBlock(), "tomes_bookshelf");
        rope = this.registerBlock((IForgeRegistry<Block>)r, new RopeBlock(Items.field_151055_y, Block.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151654_J).func_200947_a(SoundType.field_185854_g).func_200943_b(0.5f)), "rope");
        vine = this.registerBlock((IForgeRegistry<Block>)r, new RopeBlock(Items.field_222068_kQ, Block.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151669_i).func_200947_a(SoundType.field_185850_c).func_200943_b(0.5f)), "vine");
        chain = this.registerBlock((IForgeRegistry<Block>)r, new ChainBlock(Items.field_191525_da, Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200943_b(5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(0)), "chain");
        if (((Boolean)Config.climbableIronBars.get()).booleanValue()) {
            ironBars = (Block)this.register(r, (IForgeRegistryEntry)new ClimbablePaneBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151660_b).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)), new ResourceLocation("iron_bars"));
        }
        glassDoor = this.registerBlock((IForgeRegistry<Block>)r, new GlassDoorBlock(), "glass_door");
        glassTrapdoor = this.registerBlock((IForgeRegistry<Block>)r, new GlassTrapdoorBlock(), "glass_trapdoor");
        plainMulch = this.registerBlock((IForgeRegistry<Block>)r, new MulchBlock(MaterialColor.field_197656_x), "plain_mulch");
        brownMulch = this.registerBlock((IForgeRegistry<Block>)r, new MulchBlock(MaterialColor.field_151664_l), "brown_mulch");
        redMulch = this.registerBlock((IForgeRegistry<Block>)r, new MulchBlock(MaterialColor.field_151655_K), "red_mulch");
        blackMulch = this.registerBlock((IForgeRegistry<Block>)r, new MulchBlock(MaterialColor.field_151670_w), "black_mulch");
        blueMulch = this.registerBlock((IForgeRegistry<Block>)r, new MulchBlock(MaterialColor.field_151649_A), "blue_mulch");
        path_rock = this.registerBlock((IForgeRegistry<Block>)r, new PathBlock(PathBlock.SHAPE_ROCK, MaterialColor.field_151665_m), "rock_path");
        path_round = this.registerBlock((IForgeRegistry<Block>)r, new PathBlock(PathBlock.SHAPE_ROUND, MaterialColor.field_151665_m), "round_path");
        path_tile = this.registerBlock((IForgeRegistry<Block>)r, new PathBlock(PathBlock.SHAPE_TILE, MaterialColor.field_151665_m), "tile_path");
        path_brick = this.registerBlock((IForgeRegistry<Block>)r, new PathBlock(PathBlock.SHAPE_BRICK, MaterialColor.field_151645_D), "brick_path");
        flower_cyan = this.registerBlock((IForgeRegistry<Block>)r, new FlowerBlock(null), "cyan_flower");
        flower_syringa = this.registerBlock((IForgeRegistry<Block>)r, new FlowerBlock((DoublePlantBlock)Blocks.field_196801_ge), "syringa");
        flower_paeonia = this.registerBlock((IForgeRegistry<Block>)r, new FlowerBlock((DoublePlantBlock)Blocks.field_196803_gg), "paeonia");
        flower_rose = this.registerBlock((IForgeRegistry<Block>)r, new FlowerBlock((DoublePlantBlock)Blocks.field_196802_gf), "rose");
        whiteEnlightenedBush = this.registerBlock((IForgeRegistry<Block>)r, new EnlightenedBushBlock(-1), "white_enlightened_bush");
        redEnlightenedBush = this.registerBlock((IForgeRegistry<Block>)r, new EnlightenedBushBlock(0xBF0000), "red_enlightened_bush");
        greenEnlightenedBush = this.registerBlock((IForgeRegistry<Block>)r, new EnlightenedBushBlock(2522880), "green_enlightened_bush");
        blueEnlightenedBush = this.registerBlock((IForgeRegistry<Block>)r, new EnlightenedBushBlock(7359), "blue_enlightened_bush");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        for (DyeColor color : DyeColor.values()) {
            InspirationsBuilding.coloredBooks[color.func_196059_a()] = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78035_l), Config::enableColoredBooks), color.func_176610_l() + "_book");
        }
        redstoneBook = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78035_l), Config::enableRedstoneBook), "redstone_book");
        Item.Properties deco_props = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
        this.registerBlockItem(r, new TextureBlockItem((Block)shelf_normal, deco_props, (Tag<Item>)ItemTags.field_202899_i));
        this.registerBlockItem(r, new TextureBlockItem((Block)shelf_ancient, deco_props, (Tag<Item>)ItemTags.field_202899_i));
        this.registerBlockItem(r, new TextureBlockItem((Block)shelf_rainbow, deco_props, (Tag<Item>)ItemTags.field_202899_i));
        this.registerBlockItem(r, new TextureBlockItem((Block)shelf_tomes, deco_props, (Tag<Item>)ItemTags.field_202899_i));
        this.registerBlockItem((IForgeRegistry<Item>)r, rope, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, vine, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, chain, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, ironBars, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, plainMulch, ItemGroup.field_78030_b);
        this.registerBlockItem((IForgeRegistry<Item>)r, brownMulch, ItemGroup.field_78030_b);
        this.registerBlockItem((IForgeRegistry<Item>)r, redMulch, ItemGroup.field_78030_b);
        this.registerBlockItem((IForgeRegistry<Item>)r, blackMulch, ItemGroup.field_78030_b);
        this.registerBlockItem((IForgeRegistry<Item>)r, blueMulch, ItemGroup.field_78030_b);
        this.registerBlockItem((IForgeRegistry<Item>)r, path_rock, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, path_round, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, path_tile, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, path_brick, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, (Block)flower_cyan, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, (Block)flower_syringa, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, (Block)flower_paeonia, ItemGroup.field_78031_c);
        this.registerBlockItem((IForgeRegistry<Item>)r, (Block)flower_rose, ItemGroup.field_78031_c);
        this.registerBlockItem(r, new TextureBlockItem(whiteEnlightenedBush, deco_props, (Tag<Item>)ItemTags.field_206963_E));
        this.registerBlockItem(r, new TextureBlockItem(redEnlightenedBush, deco_props, (Tag<Item>)ItemTags.field_206963_E));
        this.registerBlockItem(r, new TextureBlockItem(greenEnlightenedBush, deco_props, (Tag<Item>)ItemTags.field_206963_E));
        this.registerBlockItem(r, new TextureBlockItem(blueEnlightenedBush, deco_props, (Tag<Item>)ItemTags.field_206963_E));
        glassDoorItem = this.registerItem((IForgeRegistry<Item>)r, new GlassDoorBlockItem(glassDoor, new Item.Properties().func_200916_a(ItemGroup.field_78028_d)), "glass_door");
        this.registerBlockItem((IForgeRegistry<Item>)r, glassTrapdoor, ItemGroup.field_78028_d);
    }

    @SubscribeEvent
    public static void loadLoad(LootTableLoadEvent event) {
        flower_paeonia.injectLoot(event);
        flower_rose.injectLoot(event);
        flower_syringa.injectLoot(event);
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(BuildingEvents.class);
    }

    static {
        coloredBooks = new Item[16];
    }
}

