/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.building.tileentity.BookshelfTileEntity;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import slimeknights.mantle.block.InventoryBlock;

public class BookshelfBlock
extends InventoryBlock
implements IHidable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final ImmutableMap<Direction, VoxelShape> BOUNDS;

    public BookshelfBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 5.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nonnull
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BookshelfTileEntity();
    }

    @Deprecated
    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new BookshelfTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TextureBlockUtil.updateTextureBlock(world, pos, stack);
    }

    protected boolean openGui(PlayerEntity player, World world, BlockPos pos) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new AssertionError((Object)"Needs to be server!");
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BookshelfTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableBookshelf.get();
    }

    public void func_149666_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.func_149666_a(group, items);
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        if (facing.func_176734_d() == trace.func_216354_b()) {
            return false;
        }
        if (player.func_70093_af()) {
            return world.field_72995_K || this.openGui(player, world, pos);
        }
        int book = BookshelfBlock.bookClicked(facing, pos, trace.func_216347_e());
        if (book == -1) {
            return world.field_72995_K || this.openGui(player, world, pos);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BookshelfTileEntity) {
            if (((BookshelfTileEntity)te).interact(player, hand, book)) {
                return true;
            }
            if (InspirationsRegistry.isBook(player.func_184592_cb())) {
                return false;
            }
        }
        return true;
    }

    private static int bookClicked(Direction facing, BlockPos pos, Vec3d clickWorld) {
        double z2;
        Vec3d click = new Vec3d(clickWorld.field_72450_a - (double)pos.func_177958_n(), clickWorld.field_72448_b - (double)pos.func_177956_o(), clickWorld.field_72449_c - (double)pos.func_177952_p());
        if (click.field_72448_b < 0.0625 || click.field_72448_b > 0.9375) {
            return -1;
        }
        int shelf = 0;
        if (click.field_72448_b <= 0.4375) {
            shelf = 7;
        } else if (click.field_72448_b < 0.5625) {
            return -1;
        }
        int offX = facing.func_82601_c();
        int offZ = facing.func_82599_e();
        double x1 = offX == -1 ? 0.625 : 0.0625;
        double z1 = offZ == -1 ? 0.625 : 0.0625;
        double x2 = offX == 1 ? 0.375 : 0.9375;
        double d = z2 = offZ == 1 ? 0.375 : 0.9375;
        if (click.field_72450_a < x1 || click.field_72450_a > x2 || click.field_72449_c < z1 || click.field_72449_c > z2) {
            return -1;
        }
        Direction dir = facing.func_176735_f();
        double clicked = (double)dir.func_82601_c() * click.field_72450_a + (double)dir.func_82599_e() * click.field_72449_c - 0.0625;
        if (clicked < 0.0) {
            clicked = 1.0 + clicked;
        }
        return shelf + Math.min((int)(clicked * 8.0), 6);
    }

    @Deprecated
    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity;
        if (state.func_177230_c() != newState.func_177230_c() && (tileentity = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Deprecated
    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BookshelfTileEntity) {
            return ((BookshelfTileEntity)te).getComparatorPower();
        }
        return 0;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return TextureBlockUtil.getPickBlock(world, pos, state);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        this.func_176208_a(world, pos, state, player);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        return false;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        if (!((Boolean)Config.bookshelvesBoostEnchanting.get()).booleanValue()) {
            return 0.0f;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BookshelfTileEntity) {
            return ((BookshelfTileEntity)te).getEnchantPower();
        }
        return 0.0f;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Direction side : Direction.Plane.HORIZONTAL) {
            int offX = side.func_82601_c();
            int offZ = side.func_82599_e();
            double x1 = offX == -1 ? 0.5 : 0.0;
            double z1 = offZ == -1 ? 0.5 : 0.0;
            double x2 = offX == 1 ? 0.5 : 1.0;
            double z2 = offZ == 1 ? 0.5 : 1.0;
            Vec3d min = new Vec3d(-0.4375, 0.0, -0.4375).func_178785_b(-1.5707964f * (float)side.func_176736_b());
            Vec3d max = new Vec3d(0.4375, 1.0, 0.0).func_178785_b(-1.5707964f * (float)side.func_176736_b());
            builder.put((Object)side, (Object)VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197873_a((double)x1, (double)0.0, (double)z1, (double)x2, (double)1.0, (double)z2), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)(0.5 + min.field_72450_a), (double)0.0625, (double)(0.5 + min.field_72449_c), (double)(0.5 + max.field_72450_a), (double)0.4375, (double)(0.5 + max.field_72449_c)), (VoxelShape)VoxelShapes.func_197873_a((double)(0.5 + min.field_72450_a), (double)0.5625, (double)(0.5 + min.field_72449_c), (double)(0.5 + max.field_72450_a), (double)0.9375, (double)(0.5 + max.field_72449_c))), (IBooleanFunction)IBooleanFunction.field_223234_e_));
        }
        BOUNDS = builder.build();
    }
}

