/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.building.tileentity.EnlightenedBushTileEntity;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EnlightenedBushBlock
extends Block
implements IHidable {
    private final int color;

    public EnlightenedBushBlock(int color) {
        super(Block.Properties.func_200945_a((Material)Material.field_151584_j).func_200951_a(15).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c));
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnlightenedBushTileEntity();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableEnlightenedBush.get();
    }

    @Deprecated
    public boolean func_220060_c(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Deprecated
    public boolean func_220067_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, EntityType<?> type) {
        return type == EntityType.field_200781_U || type == EntityType.field_200783_W;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TextureBlockUtil.updateTextureBlock(world, pos, stack);
    }

    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return TextureBlockUtil.getPickBlock(world, pos, state);
    }
}

