/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.tileentity.BookshelfTileEntity;
import knightminer.inspirations.shared.client.TextureModel;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;

public class BookshelfModel
extends TextureModel {
    public static final Cache<BookshelfCacheKey, IBakedModel> BOOK_CACHE = CacheBuilder.newBuilder().maximumSize(30L).build();

    public BookshelfModel(IBakedModel standard, IUnbakedModel model) {
        super(standard, model, DefaultVertexFormats.field_176600_a, "texture", false);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel bakedModel = this.originalModel;
        String texture = (String)extraData.getData(BookshelfTileEntity.TEXTURE);
        Integer booksValue = (Integer)extraData.getData(BookshelfTileEntity.BOOKS);
        int books = booksValue != null ? booksValue : 0;
        try {
            bakedModel = (IBakedModel)BOOK_CACHE.get((Object)new BookshelfCacheKey(state, texture, books), () -> {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (texture != null) {
                    builder.put((Object)"texture", (Object)texture);
                }
                for (int i = 0; i < 14; ++i) {
                    if ((books & 1 << i) != 0) continue;
                    builder.put((Object)("#book" + i), (Object)"");
                    builder.put((Object)("#bookLabel" + i), (Object)"");
                }
                return this.getTexturedModel((ImmutableMap<String, String>)builder.build());
            });
        }
        catch (ExecutionException e) {
            Inspirations.log.error((Object)e);
        }
        return bakedModel.getQuads(state, side, rand, extraData);
    }

    private static class BookshelfCacheKey {
        private BlockState state;
        @Nullable
        private String texture;
        private int books;

        BookshelfCacheKey(BlockState state, @Nullable String texture, int books) {
            this.state = state;
            this.texture = texture;
            this.books = books;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BookshelfCacheKey that = (BookshelfCacheKey)o;
            return this.books == that.books && this.state == that.state && Objects.equals(this.texture, that.texture);
        }

        public int hashCode() {
            return 31 * (31 * this.state.hashCode() + (this.texture == null ? 0 : this.texture.hashCode())) + this.books;
        }
    }
}

