/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.inventory.BookshelfContainer;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.InventorySlotSyncPacket;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.InventoryTileEntity;

public class BookshelfTileEntity
extends InventoryTileEntity {
    public static final ModelProperty<String> TEXTURE = TextureBlockUtil.TEXTURE_PROP;
    public static final ModelProperty<Integer> BOOKS = new ModelProperty();
    private float enchantBonus = Float.NaN;
    public static ITextComponent TITLE = new TranslationTextComponent("gui.inspirations.bookshelf.name", new Object[0]);

    public BookshelfTileEntity() {
        super(InspirationsBuilding.tileBookshelf, TITLE, 14, 1);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        ItemStack oldStack = this.func_70301_a(slot);
        if (this.func_145831_w() != null && this.func_145831_w() instanceof ServerWorld && !this.func_145831_w().field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            InspirationsNetwork.sendToClients((ServerWorld)this.func_145831_w(), this.field_174879_c, (AbstractPacket)new InventorySlotSyncPacket(itemstack, slot, this.field_174879_c));
        }
        super.func_70299_a(slot, itemstack);
        if (this.func_145831_w() != null) {
            if (this.func_145831_w().field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
            if (oldStack.func_77973_b() == InspirationsBuilding.redstoneBook ^ itemstack.func_77973_b() == InspirationsBuilding.redstoneBook) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
        this.enchantBonus = Float.NaN;
    }

    public boolean interact(PlayerEntity player, Hand hand, int bookClicked) {
        if (this.isStackInSlot(bookClicked)) {
            if (!this.field_145850_b.field_72995_K) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.func_70301_a(bookClicked), (int)player.field_71071_by.field_70461_c);
                this.func_70299_a(bookClicked, ItemStack.field_190927_a);
            }
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (InspirationsRegistry.isBook(stack)) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70299_a(bookClicked, stack.func_77979_a(1));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Container createMenu(int winId, PlayerInventory playerInv, PlayerEntity player) {
        return new BookshelfContainer(winId, playerInv, this);
    }

    public int getComparatorPower() {
        for (int i = 0; i < 14; ++i) {
            if (this.func_70301_a(i).func_77973_b() != InspirationsBuilding.redstoneBook) continue;
            return i + 2;
        }
        return 0;
    }

    public float getEnchantPower() {
        if (!Float.isNaN(this.enchantBonus)) {
            return this.enchantBonus;
        }
        float books = 0.0f;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            float power;
            if (!this.isStackInSlot(i) || !((power = InspirationsRegistry.getBookEnchantingPower(this.func_70301_a(i))) >= 0.0f)) continue;
            books += power;
        }
        this.enchantBonus = books / 14.0f;
        return this.enchantBonus;
    }

    @Nonnull
    public IModelData getModelData() {
        int books = 0;
        for (int i = 0; i < 14; ++i) {
            if (!this.isStackInSlot(i)) continue;
            books |= 1 << i;
        }
        ModelDataMap.Builder data = new ModelDataMap.Builder().withInitial(BOOKS, (Object)books);
        String texture = ClientUtil.getTexturePath((TileEntity)this);
        if (!texture.isEmpty()) {
            data = data.withInitial(TEXTURE, (Object)texture);
        }
        return data.build();
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = this.getTileData().func_74737_b();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        TextureBlockUtil.updateTextureBlock((TileEntity)this, tag);
        this.func_145839_a(tag);
    }
}

