/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import java.util.function.BiFunction;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.shared.client.TextureModel;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientProxy {
    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    protected static void registerBlockColors(BlockColors blockColors, IBlockColor handler, Block ... blocks) {
        for (Block block : blocks) {
            if (block == null) continue;
            blockColors.func_186722_a(handler, new Block[]{block});
        }
    }

    protected static void registerItemColors(ItemColors itemColors, IItemColor handler, Block ... blocks) {
        for (Block block : blocks) {
            Item item;
            if (block == null || (item = block.func_199767_j()) == Items.field_190931_a) continue;
            itemColors.func_199877_a(handler, new IItemProvider[]{item});
        }
    }

    protected static void registerItemColors(ItemColors itemColors, IItemColor handler, Item ... items) {
        for (Item item : items) {
            if (item == null) continue;
            itemColors.func_199877_a(handler, new IItemProvider[]{item});
        }
    }

    protected static void replaceModel(ModelBakeEvent event, ModelResourceLocation location, BiFunction<IBakedModel, IUnbakedModel, TextureModel> modelMaker) {
        try {
            IUnbakedModel model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            IBakedModel standard = (IBakedModel)event.getModelRegistry().get(location);
            TextureModel finalModel = modelMaker.apply(standard, model);
            finalModel.fetchChildren(event.getModelLoader());
            event.getModelRegistry().put(location, finalModel);
        }
        catch (Exception e) {
            Inspirations.log.error("Caught exception trying to replace model for " + location, (Throwable)e);
        }
    }

    protected static void replaceTexturedModel(ModelBakeEvent event, ModelResourceLocation location, String key, boolean item) {
        ClientProxy.replaceModel(event, location, (orig, model) -> new TextureModel((IBakedModel)orig, (IUnbakedModel)model, item ? DefaultVertexFormats.field_176599_b : DefaultVertexFormats.field_176600_a, key, item));
    }

    protected static void replaceBothTexturedModels(ModelBakeEvent event, ResourceLocation loc, String key) {
        ClientProxy.replaceTexturedModel(event, new ModelResourceLocation(loc, ""), key, false);
        ClientProxy.replaceTexturedModel(event, new ModelResourceLocation(loc, "inventory"), key, true);
    }
}

