/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import java.util.Locale;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.item.HidableBlockItem;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.common.IRegisterUtil;

public class PulseBase
implements IRegisterUtil {
    public String getModId() {
        return "inspirations";
    }

    public static boolean isBuildingLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsBuilding");
    }

    public static boolean isUtilityLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsUtility");
    }

    public static boolean isTweaksLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsTweaks");
    }

    public static boolean isRecipesLoaded() {
        return false;
    }

    public static boolean isToolsLoaded() {
        return Inspirations.pulseManager.isPulseLoaded("InspirationsTools");
    }

    protected <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        this.register((IForgeRegistry)registry, (IForgeRegistryEntry)block, name);
        return block;
    }

    protected <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        this.register((IForgeRegistry)registry, (IForgeRegistryEntry)item, name);
        return item;
    }

    public BlockItem registerBlockItem(IForgeRegistry<Item> registry, Block block, ItemGroup group) {
        if (block == null) {
            return null;
        }
        return this.registerBlockItem(registry, new HidableBlockItem(block, new Item.Properties().func_200916_a(group)));
    }

    protected static <X extends Entity> EntityType<X> buildEntity(EntityType.Builder<X> builder, String id) {
        EntityType type = builder.func_206830_a(id);
        type.setRegistryName(Util.getResource(id));
        return type;
    }

    protected static void addToVanillaLoot(LootTableLoadEvent event, String name) {
        if (!event.getName().func_110624_b().equals("minecraft") || !event.getName().func_110623_a().equals(name)) {
            return;
        }
        ResourceLocation base = new ResourceLocation(name);
        LootTable table = event.getTable();
        if (table != LootTable.field_186464_a) {
            ResourceLocation location = Util.getResource(base.func_110623_a());
            table.addPool(new LootPool.Builder().name(location.toString()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)location)).func_216044_b());
        }
    }
}

