/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigEnabledCondition
implements ICondition,
ILootCondition {
    public static final ResourceLocation ID = Util.getResource("config");
    private final String configName;
    private final BooleanSupplier supplier;
    private static Map<String, ConfigEnabledCondition> PROPS = new HashMap<String, ConfigEnabledCondition>();

    private ConfigEnabledCondition(String configName, BooleanSupplier supplier) {
        this.configName = configName;
        this.supplier = supplier;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test() {
        return this.supplier.getAsBoolean();
    }

    public boolean test(LootContext lootContext) {
        return this.supplier.getAsBoolean();
    }

    private static void add(String prop, BooleanSupplier supplier) {
        PROPS.put(prop.toLowerCase(Locale.ROOT), new ConfigEnabledCondition(prop, supplier));
    }

    private static void add(String prop, ForgeConfigSpec.BooleanValue option) {
        PROPS.put(prop.toLowerCase(Locale.ROOT), new ConfigEnabledCondition(prop, () -> ((ForgeConfigSpec.BooleanValue)option).get()));
    }

    static {
        ConfigEnabledCondition.add("bookshelf", Config.enableBookshelf);
        ConfigEnabledCondition.add("colored_books", Config::enableColoredBooks);
        ConfigEnabledCondition.add("enlightened_bush", Config.enableEnlightenedBush);
        ConfigEnabledCondition.add("flowers", Config.enableFlowers);
        ConfigEnabledCondition.add("glass_door", Config.enableGlassDoor);
        ConfigEnabledCondition.add("mulch", Config.enableMulch);
        ConfigEnabledCondition.add("path", Config.enablePath);
        ConfigEnabledCondition.add("rope", Config.enableRope);
        ConfigEnabledCondition.add("bricks_button", () -> false);
        ConfigEnabledCondition.add("carpeted_trapdoor", Config.enableCarpetedTrapdoor);
        ConfigEnabledCondition.add("collector", Config.enableCollector);
        ConfigEnabledCondition.add("pipe", Config.enablePipe);
        ConfigEnabledCondition.add("redstone_book", Config::enableRedstoneBook);
        ConfigEnabledCondition.add("torch_lever", Config.enableTorchLever);
        ConfigEnabledCondition.add("barometer", Config.enableBarometer);
        ConfigEnabledCondition.add("charged_arrow", Config.enableChargedArrow);
        ConfigEnabledCondition.add("craft_waypoint_compass", Config::craftWaypointCompass);
        ConfigEnabledCondition.add("copy_waypoint_compass", Config::copyWaypointCompass);
        ConfigEnabledCondition.add("dye_waypoint_compass", Config::dyeWaypointCompass);
        ConfigEnabledCondition.add("lock", Config.enableLock);
        ConfigEnabledCondition.add("north_compass", Config.enableNorthCompass);
        ConfigEnabledCondition.add("photometer", Config.enablePhotometer);
        ConfigEnabledCondition.add("redstone_charger", Config.enableRedstoneCharger);
        ConfigEnabledCondition.add("more_seeds", () -> false);
        ConfigEnabledCondition.add("unstackable_alts", Config.unstackableRecipeAlts);
        ConfigEnabledCondition.add("skeleton_skull", Config.skeletonSkull);
        ConfigEnabledCondition.add("cave_spider_web", Config.caveSpiderDrops);
        ConfigEnabledCondition.add("cauldron_dyeing", () -> false);
        ConfigEnabledCondition.add("cauldron_fluids", () -> false);
        ConfigEnabledCondition.add("cauldron_potions", () -> false);
        ConfigEnabledCondition.add("extra_dyed_bottle_recipes", () -> false);
        ConfigEnabledCondition.add("patch_vanilla_dye_recipes", () -> false);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<ConfigEnabledCondition>
    implements IConditionSerializer<ConfigEnabledCondition> {
        public Serializer() {
            super(ID, ConfigEnabledCondition.class);
        }

        public void write(JsonObject json, ConfigEnabledCondition value) {
            json.addProperty("prop", value.configName);
        }

        public ConfigEnabledCondition read(JsonObject json) {
            String prop = JSONUtils.func_151200_h((JsonObject)json, (String)"prop");
            ConfigEnabledCondition config = (ConfigEnabledCondition)PROPS.get(prop.toLowerCase(Locale.ROOT));
            if (config == null) {
                throw new JsonSyntaxException("Invalid propertyname '" + prop + "'");
            }
            return config;
        }

        public ResourceLocation getID() {
            return ID;
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull ConfigEnabledCondition cond, @Nonnull JsonSerializationContext ctx) {
            this.write(json, cond);
        }

        @Nonnull
        public ConfigEnabledCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext ctx) {
            return this.read(json);
        }
    }
}

