/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.Util;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class PulseLoadedCondition
implements ICondition,
ILootCondition {
    public static final ResourceLocation ID = Util.getResource("pulse_loaded");
    private final String pulseId;

    public PulseLoadedCondition(String pulseId) {
        this.pulseId = pulseId;
    }

    public boolean test() {
        return Inspirations.pulseManager.isPulseLoaded(this.pulseId);
    }

    public boolean test(LootContext lootContext) {
        return Inspirations.pulseManager.isPulseLoaded(this.pulseId);
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<PulseLoadedCondition>
    implements IConditionSerializer<PulseLoadedCondition> {
        public Serializer() {
            super(ID, PulseLoadedCondition.class);
        }

        public void write(JsonObject json, PulseLoadedCondition cond) {
            json.addProperty("pulse", cond.pulseId);
        }

        public PulseLoadedCondition read(JsonObject json) {
            String pulse = JSONUtils.func_151200_h((JsonObject)json, (String)"pulse");
            return new PulseLoadedCondition(pulse);
        }

        public ResourceLocation getID() {
            return ID;
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull PulseLoadedCondition cond, @Nonnull JsonSerializationContext ctx) {
            this.write(json, cond);
        }

        @Nonnull
        public PulseLoadedCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext ctx) {
            return this.read(json);
        }
    }
}

