/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.InventoryTileEntity;

public class InventorySlotSyncPacket
extends AbstractPacket {
    public ItemStack itemStack;
    public int slot;
    public BlockPos pos;

    private InventorySlotSyncPacket() {
    }

    public InventorySlotSyncPacket(ItemStack itemStack, int slot, BlockPos pos) {
        this.itemStack = itemStack;
        this.pos = pos;
        this.slot = slot;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        switch (context.get().getDirection()) {
            case LOGIN_TO_SERVER: 
            case PLAY_TO_SERVER: {
                throw new UnsupportedOperationException("Clientside only");
            }
        }
        context.get().setPacketHandled(true);
        TileEntity tileEntity = (TileEntity)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_175625_s(this.pos));
        if (!(tileEntity instanceof InventoryTileEntity)) {
            return;
        }
        InventoryTileEntity tile = (InventoryTileEntity)tileEntity;
        tile.func_70299_a(this.slot, this.itemStack);
        Minecraft.func_71410_x().field_71438_f.func_184376_a(null, this.pos, null, null, 3);
        ModelDataManager.requestModelDataRefresh((TileEntity)tile);
    }

    public static InventorySlotSyncPacket decode(PacketBuffer buf) {
        InventorySlotSyncPacket packet = new InventorySlotSyncPacket();
        packet.pos = packet.readPos((ByteBuf)buf);
        packet.slot = buf.readShort();
        packet.itemStack = buf.func_150791_c();
        return packet;
    }

    public void encode(PacketBuffer buf) {
        this.writePos(this.pos, (ByteBuf)buf);
        buf.writeShort(this.slot);
        buf.writeItemStack(this.itemStack, false);
    }
}

