/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.AbstractPacket;

public class MilkablePacket
extends AbstractPacket {
    private int entityID;
    private boolean milkable;

    private MilkablePacket() {
    }

    public MilkablePacket(Entity entity, boolean milkable) {
        this.entityID = entity.func_145782_y();
        this.milkable = milkable;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.milkable);
    }

    public static MilkablePacket decode(PacketBuffer buf) {
        MilkablePacket packet = new MilkablePacket();
        packet.entityID = buf.readInt();
        packet.milkable = buf.readBoolean();
        return packet;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        switch (context.get().getDirection()) {
            case LOGIN_TO_SERVER: 
            case PLAY_TO_SERVER: {
                throw new UnsupportedOperationException("Clientside only");
            }
        }
        context.get().setPacketHandled(true);
        Entity entity = (Entity)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID));
        if (entity == null) {
            return;
        }
        CompoundNBT tags = entity.getPersistentData();
        tags.func_74777_a("milk_cooldown", (short)(this.milkable ? 0 : 100));
    }
}

