/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.event.RegisterEvent;
import knightminer.inspirations.library.recipe.cauldron.FillCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.FluidCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.FluidTransformCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.RecipeMatch;

public class InspirationsRegistry {
    public static final Logger log = Util.getLogger("api");
    public static final Tag<Block> TAG_CAULDRON_FIRE = new BlockTags.Wrapper(new ResourceLocation("inspirations", "cauldron_fire"));
    public static final Tag<Item> TAG_DISP_FLUID_TANKS = new ItemTags.Wrapper(new ResourceLocation("inspirations", "fluid_containers"));
    public static final Tag<Item> TAG_DISP_CAULDRON_RECIPES = new ItemTags.Wrapper(new ResourceLocation("inspirations", "cauldron_recipes"));
    public static final Tag<Item> TAG_MILK_CONTAINERS = new ItemTags.Wrapper(new ResourceLocation("inspirations", "milk_containers"));
    public static final ToolType SHEAR_TYPE = ToolType.get((String)"shears");
    public static final Tag<Item> TAG_DYE_BOTTLES = new ItemTags.Wrapper(Util.getResource("dyed_water_bottles"));
    private static Map<Item, Float> books = new HashMap<Item, Float>();
    private static Map<Item, Float> bookCache = new HashMap<Item, Float>();
    private static List<String> bookKeywords = new ArrayList<String>();
    private static float defaultEnchantingPower = 1.5f;
    private static Map<BlockState, BlockState> anvilSmashing = new HashMap<BlockState, BlockState>();
    private static Map<Block, BlockState> anvilSmashingBlocks = new HashMap<Block, BlockState>();
    private static Set<Material> anvilBreaking = new HashSet<Material>();
    private static List<ICauldronRecipe> cauldronRecipes = new ArrayList<ICauldronRecipe>();
    private static Set<Item> cauldronBlacklist = new HashSet<Item>();
    private static boolean cauldronBigger = false;
    private static boolean expensiveCauldronBrewing = false;
    private static Set<Fluid> cauldronWater = new HashSet<Fluid>();
    private static Map<Block, ICauldronRecipe.CauldronState> cauldronBlockStates = new HashMap<Block, ICauldronRecipe.CauldronState>();
    private static Map<ICauldronRecipe.CauldronState, BlockState> cauldronFullStates = new HashMap<ICauldronRecipe.CauldronState, BlockState>();

    @Deprecated
    public static void setConfig(String key, boolean value) {
        switch (key) {
            case "biggerCauldron": {
                cauldronBigger = value;
                break;
            }
            case "expensiveCauldronBrewing": {
                expensiveCauldronBrewing = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected config key " + key);
            }
        }
    }

    public static void setDefaultEnchantingPower(float power) {
        defaultEnchantingPower = power;
    }

    public static boolean isBook(ItemStack stack) {
        return !stack.func_190926_b() && InspirationsRegistry.getBookEnchantingPower(stack) >= 0.0f;
    }

    public static float getBookEnchantingPower(ItemStack book) {
        if (book.func_190926_b()) {
            return 0.0f;
        }
        return bookCache.computeIfAbsent(book.func_77973_b(), InspirationsRegistry::bookPower).floatValue();
    }

    @Nonnull
    private static Float bookPower(Item item) {
        Float override = books.get(item);
        if (override != null) {
            return override;
        }
        if (Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            return Float.valueOf(-1.0f);
        }
        for (String keyword : bookKeywords) {
            if (!item.getRegistryName().func_110623_a().contains(keyword) && !item.func_77658_a().contains(keyword)) continue;
            return Float.valueOf(defaultEnchantingPower);
        }
        return Float.valueOf(-1.0f);
    }

    @Deprecated
    public static void registerBook(Item item, boolean isBook) {
        books.put(item, Float.valueOf(isBook ? 1.5f : -1.0f));
    }

    public static void registerBook(Item item, float power) {
        books.put(item, Float.valueOf(power));
    }

    public static void setBookKeywords(List<String> keywords) {
        bookKeywords = keywords;
        bookCache.clear();
    }

    public static void registerAnvilSmashing(BlockState input, BlockState result) {
        anvilSmashing.put(input, result);
    }

    public static void registerAnvilSmashing(BlockState input, Block result) {
        InspirationsRegistry.registerAnvilSmashing(input, result.func_176223_P());
    }

    public static void registerAnvilBreaking(BlockState input) {
        InspirationsRegistry.registerAnvilSmashing(input, Blocks.field_150350_a);
    }

    public static void registerAnvilSmashing(Block input, BlockState result) {
        anvilSmashingBlocks.put(input, result);
    }

    public static void registerAnvilSmashing(Block input, Block result) {
        InspirationsRegistry.registerAnvilSmashing(input, result.func_176223_P());
    }

    public static void registerAnvilBreaking(Block input) {
        InspirationsRegistry.registerAnvilSmashing(input, Blocks.field_150350_a);
    }

    public static void registerAnvilBreaking(Material material) {
        anvilBreaking.add(material);
    }

    public static BlockState getAnvilSmashResult(BlockState state) {
        if (anvilSmashing.containsKey(state)) {
            return anvilSmashing.get(state);
        }
        Block block = state.func_177230_c();
        if (anvilSmashingBlocks.containsKey(block)) {
            return anvilSmashingBlocks.get(block);
        }
        if (anvilBreaking.contains(state.func_185904_a())) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return null;
    }

    public static boolean hasAnvilSmashStateResult(BlockState state) {
        return anvilSmashing.containsKey(state);
    }

    public static List<Map.Entry<BlockState, BlockState>> getAllAnvilStateSmashing() {
        return ImmutableList.copyOf(anvilSmashing.entrySet());
    }

    public static List<Map.Entry<Block, BlockState>> getAllAnvilBlockSmashing() {
        return ImmutableList.copyOf(anvilSmashingBlocks.entrySet());
    }

    public static ICauldronRecipe getCauldronResult(ItemStack input, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        for (ICauldronRecipe recipe : cauldronRecipes) {
            if (!recipe.matches(input, boiling, level, state)) continue;
            return recipe;
        }
        return null;
    }

    public static void addCauldronRecipe(ICauldronRecipe recipe) {
        if (new RegisterEvent.RegisterCauldronRecipe(recipe).fire()) {
            cauldronRecipes.add(recipe);
        } else {
            log.debug("Cauldron recipe '{}' canceled by event", (Object)recipe);
        }
    }

    public static void addCauldronRecipe(ItemStack input, ItemStack output, Boolean boiling) {
        InspirationsRegistry.addCauldronRecipe(new FluidCauldronRecipe(RecipeMatch.of((ItemStack)input), output, boiling));
    }

    public static void addCauldronScaledTransformRecipe(ItemStack stack, Fluid input, Fluid output, Boolean boiling) {
        InspirationsRegistry.addCauldronRecipe(new FluidTransformCauldronRecipe(RecipeMatch.of((ItemStack)stack, (int)stack.func_190916_E(), (int)1), input, output, boiling, 1));
        stack = stack.func_77946_l();
        int count = stack.func_190916_E();
        stack.func_190920_e(count * 2);
        if (cauldronBigger) {
            InspirationsRegistry.addCauldronRecipe(new FluidTransformCauldronRecipe(RecipeMatch.of((ItemStack)stack, (int)stack.func_190916_E(), (int)1), input, output, boiling, 2));
            stack = stack.func_77946_l();
            stack.func_190920_e(count * 3);
        }
        InspirationsRegistry.addCauldronRecipe(new FluidTransformCauldronRecipe(RecipeMatch.of((ItemStack)stack, (int)stack.func_190916_E(), (int)1), input, output, boiling, cauldronBigger ? 4 : 3));
    }

    public static void addCauldronFluidItem(ItemStack filled, ItemStack container, Fluid fluid, int amount) {
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((ItemStack)filled), fluid, amount, container.func_77946_l()));
        InspirationsRegistry.addCauldronRecipe(new FluidCauldronRecipe(RecipeMatch.of((ItemStack)container), fluid, filled.func_77946_l(), null, amount, SoundEvents.field_187615_H));
    }

    public static void addCauldronFluidItem(ItemStack filled, ItemStack container, Fluid fluid) {
        InspirationsRegistry.addCauldronFluidItem(filled, container, fluid, 1);
    }

    public static List<ICauldronRecipe> getAllCauldronRecipes() {
        return ImmutableList.copyOf(cauldronRecipes);
    }

    public static void addCauldronBlacklist(Item item) {
        cauldronBlacklist.add(item);
    }

    public static boolean isCauldronBlacklist(ItemStack stack) {
        return cauldronBlacklist.contains(stack.func_77973_b());
    }

    public static int getCauldronMax() {
        return cauldronBigger ? 4 : 3;
    }

    public static boolean expensiveCauldronBrewing() {
        return expensiveCauldronBrewing;
    }

    public static void addCauldronWater(Fluid fluid) {
        cauldronWater.add(fluid);
    }

    public static boolean isCauldronWater(Fluid fluid) {
        return fluid != null && cauldronWater.contains(fluid);
    }

    public static boolean isCauldronFire(BlockState state) {
        if (state.func_177230_c().func_203417_a(TAG_CAULDRON_FIRE)) {
            return true;
        }
        return state.func_177230_c() == Blocks.field_222433_lV && (Boolean)state.func_177229_b((IProperty)CampfireBlock.field_220101_b) != false;
    }

    public static void registerDefaultCauldron() {
        cauldronBlockStates.put(Blocks.field_150383_bp, ICauldronRecipe.CauldronState.WATER);
    }

    public static void registerFullCauldron(BlockState state, ICauldronRecipe.CauldronState cauldronState) {
        cauldronBlockStates.put(state.func_177230_c(), cauldronState);
        cauldronFullStates.put(cauldronState, state);
    }

    public static boolean isNormalCauldron(BlockState state) {
        return cauldronBlockStates.containsKey(state.func_177230_c());
    }

    public static ICauldronRecipe.CauldronState getCauldronState(BlockState state) {
        Block block = state.func_177230_c();
        if (cauldronBlockStates.containsKey(block)) {
            return cauldronBlockStates.get(block);
        }
        throw new IllegalArgumentException("Attempted to get state of a cauldron that is not registered");
    }

    public static boolean hasFullCauldron(ICauldronRecipe.CauldronState state) {
        return cauldronFullStates.containsKey(state);
    }

    @Nullable
    public static BlockState getFullCauldron(ICauldronRecipe.CauldronState state) {
        return cauldronFullStates.get(state);
    }
}

