/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static ItemStack silkTouchItem = new ItemStack((IItemProvider)Items.field_151055_y);

    public static String resource(String name) {
        return String.format("%s:%s", "inspirations", name.toLowerCase(Locale.US));
    }

    public static String prefix(String name) {
        return String.format("%s.%s", "inspirations", name.toLowerCase(Locale.US));
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation("inspirations", res);
    }

    public static Logger getLogger(String type) {
        String log = "inspirations";
        return LogManager.getLogger((String)(log + "-" + type));
    }

    public static boolean clickedAABB(AxisAlignedBB aabb, Vec3d hit) {
        return aabb.field_72340_a <= hit.field_72450_a && hit.field_72450_a <= aabb.field_72336_d && aabb.field_72338_b <= hit.field_72448_b && hit.field_72448_b <= aabb.field_72337_e && aabb.field_72339_c <= hit.field_72449_c && hit.field_72449_c <= aabb.field_72334_f;
    }

    public static ItemStack getStackFromState(ServerWorld world, @Nullable BlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        List drops = state.func_215693_a(new LootContext.Builder(world).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos(0, 0, 64)).func_216015_a(LootParameters.field_216289_i, (Object)silkTouchItem));
        if (drops.size() > 0) {
            return (ItemStack)drops.get(0);
        }
        InspirationsRegistry.log.error("Failed to get silk touch drop for {}, using fallback", (Object)state);
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item);
    }

    @SafeVarargs
    public static <E> NonNullList<E> createNonNullList(E ... elements) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static int combineColors(int color1, int color2, int scale) {
        if (scale == 0) {
            return color1;
        }
        int a = color1 >> 24 & 0xFF;
        int r = color1 >> 16 & 0xFF;
        int g = color1 >> 8 & 0xFF;
        int b = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        for (int i = 0; i < scale; ++i) {
            a = (int)Math.sqrt(a * a2);
            r = (int)Math.sqrt(r * r2);
            g = (int)Math.sqrt(g * g2);
            b = (int)Math.sqrt(b * b2);
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static float[] getColorComponents(int color) {
        int i = (color & 0xFFFFFF) >> 16;
        int j = (color & 0xFFFF) >> 8;
        int k = color & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    public static int getColorInteger(@Nonnull float[] component) {
        return ((int)(component[0] * 255.0f) & 0xFF) << 16 | ((int)(component[1] * 255.0f) & 0xFF) << 8 | (int)(component[2] * 255.0f) & 0xFF;
    }

    public static void addPotionTooltip(Potion potionType, List<ITextComponent> lores) {
        List effects = potionType.func_185170_a();
        if (effects.isEmpty()) {
            lores.add(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
            return;
        }
        for (EffectInstance effect : effects) {
            ITextComponent effectString = effect.func_188419_a().func_199286_c();
            Effect potion = effect.func_188419_a();
            if (effect.func_76458_c() > 0) {
                effectString.func_150258_a(" ");
                effectString.func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + effect.func_76458_c(), new Object[0]));
            }
            if (effect.func_76459_b() > 20) {
                effectString.func_150257_a((ITextComponent)new StringTextComponent(" (" + EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f) + ")"));
            }
            effectString.func_211708_a(potion.func_188408_i() ? TextFormatting.BLUE : TextFormatting.RED);
            lores.add(effectString);
        }
    }

    public static DyeColor getDyeForColor(int color) {
        for (DyeColor dyeColor : DyeColor.values()) {
            if (dyeColor.func_196059_a() != color) continue;
            return dyeColor;
        }
        return null;
    }

    static {
        silkTouchItem.func_77966_a(Enchantments.field_185306_r, 1);
    }
}

