/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;
import slimeknights.mantle.client.ModelHelper;

public final class ClientUtil {
    public static final String TAG_TEXTURE_PATH = "texture_path";
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static Map<Item, Integer> colorCache = new HashMap<Item, Integer>();
    private static Set<Item> unsafe = new HashSet<Item>();
    private static final Map<String, String> NORMALIZED_NAMES = new HashMap<String, String>();

    private ClientUtil() {
    }

    public static int getItemColor(Item item) {
        return colorCache.computeIfAbsent(item, ClientUtil::getItemColorRaw);
    }

    private static Integer getItemColorRaw(Item key) {
        IBakedModel model = mc.func_175599_af().func_184393_a(new ItemStack((IItemProvider)key), null, null);
        if (model == null) {
            return -1;
        }
        TextureAtlasSprite sprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        if (sprite == null) {
            return -1;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float count = 0.0f;
        float[] hsb = new float[3];
        try {
            for (int x = 0; x < sprite.func_94211_a(); ++x) {
                for (int y = 0; y < sprite.func_94216_b(); ++y) {
                    int argb = sprite.getPixelRGBA(0, x, y);
                    int cr = argb & 0xFF;
                    int cg = argb >> 8 & 0xFF;
                    int cb = argb >> 16 & 0xFF;
                    int ca = argb >> 24 & 0xFF;
                    if (ca <= 127 || NumberUtils.max((int)cr, (int)cg, (int)cb) <= 31) continue;
                    Color.RGBtoHSB(ca, cr, cg, hsb);
                    float weight = hsb[1];
                    r += (float)cr * weight;
                    g += (float)cg * weight;
                    b += (float)cb * weight;
                    count += weight;
                }
            }
        }
        catch (NullPointerException e) {
            InspirationsRegistry.log.error("Caught exception reading sprite for " + key.getRegistryName(), (Throwable)e);
            return -1;
        }
        if (count > 0.0f) {
            r /= count;
            g /= count;
            b /= count;
        }
        return 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static void clearCache() {
        colorCache.clear();
        unsafe.clear();
    }

    public static TextureAtlasSprite getSprite(ResourceLocation location) {
        AtlasTexture textureMapBlocks = mc.func_147117_R();
        TextureAtlasSprite sprite = null;
        if (location != null) {
            sprite = textureMapBlocks.func_195424_a(location);
        }
        if (sprite == null) {
            sprite = textureMapBlocks.func_195424_a(MissingTextureSprite.func_195675_b());
        }
        return sprite;
    }

    public static void renderFilledSprite(TextureAtlasSprite sprite, int x, int y, int size, int filled) {
        double uMin = sprite.func_94209_e();
        double uMax = sprite.func_94212_f();
        double vMin = sprite.func_94206_g();
        double vMax = sprite.func_94210_h();
        uMax -= (double)(16 - size) / 16.0 * (uMax - uMin);
        vMax -= (double)(16 - filled) / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)(y + size), 100.0).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + size), (double)(y + size), 100.0).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + size), (double)(y + size - filled), 100.0).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)(y + size - filled), 100.0).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static String getTexturePath(TileEntity te) {
        Block block;
        String texture = te.getTileData().func_74779_i(TAG_TEXTURE_PATH);
        if (texture.isEmpty() && (block = TextureBlockUtil.getTextureBlock(te)) != Blocks.field_150350_a) {
            texture = ModelHelper.getTextureFromBlockstate((BlockState)block.func_176223_P()).func_195668_m().toString();
            te.getTileData().func_74778_a(TAG_TEXTURE_PATH, texture);
        }
        return texture;
    }

    public static int getStackBlockColorsSafe(ItemStack stack, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b()) {
            return -1;
        }
        Item item = stack.func_77973_b();
        if (!unsafe.contains(item)) {
            try {
                return ClientUtil.getStackBlockColors(stack, world, pos, index);
            }
            catch (Exception e) {
                Inspirations.log.error(String.format("Caught exception getting block colors for %s", item.getRegistryName()), (Throwable)e);
                unsafe.add(item);
            }
        }
        return mc.getItemColors().func_186728_a(stack, index);
    }

    public static int getStackBlockColors(ItemStack stack, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
            return -1;
        }
        BlockItem item = (BlockItem)stack.func_77973_b();
        BlockState state = item.func_179223_d().func_176223_P();
        return mc.func_184125_al().func_216860_a(state, world, pos, index);
    }

    public static void renderJEICauldronFluid(int x, int y, ResourceLocation location, float[] color, int level) {
        GlStateManager.enableBlend();
        ClientUtil.mc.field_71460_t.func_180436_i();
        GlStateManager.color3f((float)color[0], (float)color[1], (float)color[2]);
        TextureAtlasSprite sprite = ClientUtil.getSprite(location);
        if (level == 0) {
            ClientUtil.renderFilledSprite(sprite, x, y, 16, 16);
        } else {
            int height = 10 * level / InspirationsRegistry.getCauldronMax();
            ClientUtil.renderFilledSprite(sprite, x, y, 10, height);
        }
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
    }

    public static String normalizeName(String name) {
        return NORMALIZED_NAMES.computeIfAbsent(name, s -> WordUtils.capitalizeFully((String)name.replace('_', ' ')));
    }
}

