/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import knightminer.inspirations.library.util.TagUtil;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TextureRecipe
extends ShapedRecipe {
    public final Ingredient texture;
    public final boolean matchFirst;
    public static final IRecipeSerializer<?> SERIALIZER = (IRecipeSerializer)new Serializer().setRegistryName(new ResourceLocation("inspirations", "texture_recipe"));

    protected TextureRecipe(ShapedRecipe orig, Ingredient texture, boolean matchFirst) {
        super(orig.func_199560_c(), orig.func_193358_e(), orig.func_192403_f(), orig.func_192404_g(), orig.func_192400_c(), orig.func_77571_b());
        this.texture = texture;
        this.matchFirst = matchFirst;
    }

    @Nonnull
    public ItemStack func_77572_b(CraftingInventory craftMatrix) {
        ItemStack result = super.func_77572_b(craftMatrix);
        Block texBlock = null;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            Block block;
            ItemStack stack = craftMatrix.func_70301_a(i);
            if (stack.func_190926_b() || !this.texture.test(stack) || (block = stack.func_77973_b() == result.func_77973_b() ? TextureBlockUtil.getTextureBlock(stack) : Block.func_149634_a((Item)stack.func_77973_b())) == Blocks.field_150350_a) continue;
            if (texBlock == null) {
                texBlock = block;
                if (!this.matchFirst) continue;
                break;
            }
            if (texBlock == block) continue;
            texBlock = null;
            break;
        }
        if (texBlock != null) {
            return TextureBlockUtil.setStackTexture(result, texBlock);
        }
        return result;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TextureRecipe> {
        private Serializer() {
        }

        public TextureRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)field_222157_a.func_199425_a_(recipeId, json);
            Ingredient texture = CraftingHelper.getIngredient((JsonElement)TagUtil.getElement(json, "texture"));
            boolean matchFirst = false;
            if (json.has("match_first")) {
                matchFirst = json.get("match_first").getAsBoolean();
            }
            return new TextureRecipe(recipe, texture, matchFirst);
        }

        public TextureRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe recipe = (ShapedRecipe)field_222157_a.func_199426_a_(recipeId, buffer);
            return new TextureRecipe(recipe, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readBoolean());
        }

        public void write(PacketBuffer buffer, TextureRecipe recipe) {
            field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
            recipe.texture.func_199564_a(buffer);
            buffer.writeBoolean(recipe.matchFirst);
        }
    }
}

