/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

@ParametersAreNonnullByDefault
public class BrewingCauldronRecipe
implements ISimpleCauldronRecipe {
    private Ingredient reagent;
    private ICauldronRecipe.CauldronState input;
    private ICauldronRecipe.CauldronState output;

    public BrewingCauldronRecipe(Potion input, Ingredient reagent, Potion output) {
        this.input = ICauldronRecipe.CauldronState.potion(input);
        this.reagent = reagent;
        this.output = ICauldronRecipe.CauldronState.potion(output);
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return level > 0 && boiling && (!InspirationsRegistry.expensiveCauldronBrewing() || level < 3 || stack.func_190916_E() > 1) && state.matches(this.input) && this.reagent.test(stack);
    }

    @Override
    public ItemStack transformInput(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        stack.func_190918_g(InspirationsRegistry.expensiveCauldronBrewing() && level > 2 ? 2 : 1);
        return stack;
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return this.output;
    }

    @Override
    public List<ItemStack> getInput() {
        return ImmutableList.copyOf((Object[])this.reagent.func_193365_a());
    }

    @Override
    public int getInputLevel() {
        return InspirationsRegistry.expensiveCauldronBrewing() ? 2 : InspirationsRegistry.getCauldronMax();
    }

    @Override
    public Object getInputState() {
        Potion potion = this.input.getPotion();
        return potion == Potions.field_185230_b ? Fluids.field_204546_a : potion;
    }

    @Override
    public Object getState() {
        Potion potion = this.output.getPotion();
        return potion == Potions.field_185230_b ? Fluids.field_204546_a : potion;
    }

    @Override
    public boolean isBoiling() {
        return true;
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return SoundEvents.field_187621_J;
    }

    public String toString() {
        return String.format("BrewingCauldronRecipe: %s from %s", this.output.getPotion().getRegistryName(), this.input.getPotion().getRegistryName());
    }
}

