/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.FluidCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.util.RecipeMatch;

@ParametersAreNonnullByDefault
public class FluidTransformCauldronRecipe
extends FluidCauldronRecipe {
    private ICauldronRecipe.CauldronState result;
    private int maxLevel;

    public FluidTransformCauldronRecipe(RecipeMatch input, Fluid fluid, Fluid result, @Nullable Boolean boiling) {
        this(input, fluid, result, boiling, InspirationsRegistry.getCauldronMax());
    }

    public FluidTransformCauldronRecipe(RecipeMatch input, Fluid fluid, Fluid result, @Nullable Boolean boiling, int maxLevel) {
        super(input, fluid, ItemStack.field_190927_a, boiling);
        this.result = ICauldronRecipe.CauldronState.fluid(result);
        this.maxLevel = maxLevel;
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return level > 0 && level <= this.maxLevel && super.matches(stack, boiling, level, state);
    }

    @Override
    public int getLevel(int level) {
        return level;
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return this.result;
    }

    @Override
    public Object getState() {
        return this.result.getFluid();
    }

    @Override
    public int getInputLevel() {
        return this.maxLevel;
    }

    @Override
    public String toString() {
        return String.format("FluidTransformCauldronRecipe: %s from %s", this.result.getFluid().getRegistryName(), this.fluid == ICauldronRecipe.CauldronState.WATER ? "water" : this.fluid.getFluid().getRegistryName());
    }
}

