/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import javax.annotation.Nonnull;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public interface ICauldronRecipe {
    public boolean matches(ItemStack var1, boolean var2, int var3, CauldronState var4);

    default public ItemStack getResult(ItemStack stack, boolean boiling, int level, CauldronState state) {
        return ItemStack.field_190927_a;
    }

    default public ItemStack transformInput(ItemStack stack, boolean boiling, int level, CauldronState state) {
        stack.func_190918_g(1);
        return stack;
    }

    default public int getLevel(int level) {
        return level;
    }

    default public CauldronState getState(ItemStack stack, boolean boiling, int level, CauldronState state) {
        return state;
    }

    default public SoundEvent getSound(ItemStack stack, boolean boiling, int level, CauldronState state) {
        return SoundEvents.field_187609_F;
    }

    default public float getVolume(SoundEvent sound) {
        return sound == SoundEvents.field_187609_F ? 0.3f : 1.0f;
    }

    default public ItemStack getContainer(ItemStack stack) {
        return stack.func_77973_b().getContainerItem(stack).func_77946_l();
    }

    public static class CauldronState {
        private int color = -1;
        private Potion potion = null;
        private FluidStack fluid = null;
        public static final CauldronState WATER = new CauldronState();
        public static final String TAG_WATER = "water";
        public static final String TAG_COLOR = "color";
        public static final String TAG_POTION = "potion";
        public static final String TAG_FLUID = "fluid";

        private CauldronState() {
        }

        public static CauldronState dye(int color) {
            if (color == -1) {
                return WATER;
            }
            CauldronState state = new CauldronState();
            state.color = color;
            return state;
        }

        public static CauldronState potion(Potion potion) {
            if (potion == Potions.field_185230_b) {
                return WATER;
            }
            CauldronState state = new CauldronState();
            state.potion = potion;
            return state;
        }

        public static CauldronState fluid(Fluid fluid) {
            if (fluid == null) {
                return WATER;
            }
            CauldronState state = new CauldronState();
            state.fluid = new FluidStack(fluid, 1000);
            return state;
        }

        public boolean isWater() {
            return this == WATER || this.fluid != null && InspirationsRegistry.isCauldronWater(this.fluid.getFluid());
        }

        public int getColor() {
            return this.color;
        }

        public Potion getPotion() {
            if (this == WATER) {
                return Potions.field_185230_b;
            }
            return this.potion;
        }

        @Nonnull
        public Fluid getFluid() {
            if (this == WATER) {
                return Fluids.field_204546_a;
            }
            return this.fluid == null ? Fluids.field_204541_a : this.fluid.getFluid();
        }

        @Nonnull
        public FluidStack getFluidStack() {
            if (this == WATER) {
                return new FluidStack((Fluid)Fluids.field_204546_a, 1000);
            }
            return this.fluid == null ? FluidStack.EMPTY : this.fluid.copy();
        }

        public boolean matches(CauldronState state) {
            return this == state || state.color == this.color && state.potion == this.potion && state.getFluid() == this.getFluid();
        }

        public static boolean fluidValid(FluidStack fluid) {
            return fluid.getAmount() == 1000 && !fluid.hasTag();
        }

        public static CauldronState fromNBT(CompoundNBT tags) {
            Fluid fluid;
            if (tags.func_74767_n(TAG_WATER)) {
                return WATER;
            }
            CauldronState state = new CauldronState();
            if (tags.func_74764_b(TAG_COLOR)) {
                state.color = tags.func_74762_e(TAG_COLOR);
            }
            if (tags.func_74764_b(TAG_POTION)) {
                state.potion = Potion.func_185168_a((String)tags.func_74779_i(TAG_POTION));
            }
            if (tags.func_74764_b(TAG_FLUID) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tags.func_74779_i(TAG_FLUID)))) != null && fluid != Fluids.field_204541_a) {
                state.fluid = new FluidStack(fluid, 1000);
            }
            return state;
        }

        @Nonnull
        public CompoundNBT writeToNBT() {
            CompoundNBT tags = new CompoundNBT();
            if (this == WATER) {
                tags.func_74757_a(TAG_WATER, true);
                return tags;
            }
            if (this.color > -1) {
                tags.func_74768_a(TAG_COLOR, this.color);
            }
            if (this.potion != null) {
                tags.func_74778_a(TAG_POTION, this.potion.getRegistryName().toString());
            }
            if (this.fluid != null) {
                tags.func_74778_a(TAG_FLUID, this.fluid.getFluid().getRegistryName().toString());
            }
            return tags;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.matches((CauldronState)other);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.color > -1) {
                hashCode = this.color;
            }
            if (this.potion != null) {
                hashCode = hashCode * 31 + this.potion.hashCode();
            }
            if (this.fluid != null) {
                hashCode = hashCode * 31 + this.fluid.getFluid().getRegistryName().hashCode();
            }
            return hashCode;
        }
    }
}

