/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import com.google.common.collect.ImmutableList;
import java.util.List;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MixCauldronRecipe
implements ISimpleCauldronRecipe {
    private ICauldronRecipe.CauldronState input1;
    private ICauldronRecipe.CauldronState input2;
    private ItemStack result;

    public MixCauldronRecipe(Fluid input1, Fluid input2, ItemStack result) {
        this.result = result;
        this.input1 = ICauldronRecipe.CauldronState.fluid(input1);
        this.input2 = ICauldronRecipe.CauldronState.fluid(input2);
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level != InspirationsRegistry.getCauldronMax() || state.getFluid() == Fluids.field_204541_a) {
            return false;
        }
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)stack).map(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!ICauldronRecipe.CauldronState.fluidValid(fluidStack)) {
                return false;
            }
            Fluid fluid = fluidStack.getFluid();
            return this.input1.matches(state) && this.input2.getFluid() == fluid || this.input2.matches(state) && this.input1.getFluid() == fluid;
        }).orElse((Object)false);
    }

    @Override
    public int getLevel(int level) {
        return 0;
    }

    public Fluid getInputState() {
        return this.input1.getFluid();
    }

    @Override
    public List<ItemStack> getInput() {
        return ImmutableList.of((Object)FluidUtil.getFilledBucket((FluidStack)this.input2.getFluidStack()));
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public String toString() {
        return String.format("MixCauldronRecipe: %s from %s and %s", this.getResult().toString(), this.input1.getFluid().getRegistryName(), this.input2.getFluid().getRegistryName());
    }
}

