/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.util;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecipeUtil {
    private static final Logger log = LogManager.getLogger((String)"inspirations-lib");

    private RecipeUtil() {
    }

    public static boolean isValidItemStack(String string, boolean allowWildcard) {
        return string.matches("^[a-z0-9_.-]+:[a-z0-9_.-]+$");
    }

    public static ItemStack getItemStackFromString(String string, boolean allowWildcard) {
        if (!RecipeUtil.isValidItemStack(string, allowWildcard)) {
            log.warn("Invalid stack string {}", (Object)string);
            return ItemStack.field_190927_a;
        }
        String[] parts = string.split(":");
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(parts[0], parts[1]));
        if (item == null || item == Items.field_190931_a) {
            log.debug("Failed to find stack {}", (Object)string);
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item);
    }

    public static void forStackInString(String string, Consumer<ItemStack> callback) {
        ItemStack stack = RecipeUtil.getItemStackFromString(string, true);
        if (stack.func_190926_b()) {
            return;
        }
        NonNullList subItems = NonNullList.func_191196_a();
        stack.func_77973_b().func_150895_a(ItemGroup.field_78027_g, subItems);
        for (ItemStack subStack : subItems) {
            callback.accept(subStack);
        }
    }

    @Nullable
    private static Block getBlockFromString(String string) {
        if (!RecipeUtil.isValidItemStack(string, false)) {
            log.warn("Invalid block string {}", (Object)string);
            return null;
        }
        Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(string));
        if (block == null || block == Blocks.field_150350_a) {
            log.debug("Failed to find block {}", (Object)string);
            return null;
        }
        return block;
    }

    @Nullable
    public static BlockState getBlockStateFromString(String string) {
        Block block = RecipeUtil.getBlockFromString(string);
        return block == null ? null : block.func_176223_P();
    }

    public static void forBlockInString(String string, Consumer<BlockState> stateConsumer, Consumer<Block> blockConsumer) {
        Block block = RecipeUtil.getBlockFromString(string);
        if (block == null) {
            return;
        }
        if (blockConsumer == null) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                stateConsumer.accept(state);
            }
        } else {
            blockConsumer.accept(block);
        }
    }
}

