/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public final class ReflectionUtil {
    private static final Map<String, Field> FIELDS = new HashMap<String, Field>();
    private static final Map<String, Method> METHODS = new HashMap<String, Method>();
    private static final Map<String, Class<?>> CLASS = new HashMap();

    private ReflectionUtil() {
    }

    @Nullable
    public static <T extends ForgeRegistryEntry<T>> T getMixPredicateInput(@Nonnull Object mixPredicate) {
        IRegistryDelegate effect = (IRegistryDelegate)ReflectionUtil.getPrivateValue(ReflectionUtil.getClass("net.minecraft.potion.PotionBrewing$MixPredicate"), mixPredicate, "field_185198_a");
        return (T)((ForgeRegistryEntry)effect.get());
    }

    @Nullable
    public static Ingredient getMixPredicateReagent(@Nonnull Object mixPredicate) {
        return (Ingredient)ReflectionUtil.getPrivateValue(ReflectionUtil.getClass("net.minecraft.potion.PotionBrewing$MixPredicate"), mixPredicate, "field_185199_b");
    }

    @Nullable
    public static <T extends ForgeRegistryEntry<T>> T getMixPredicateOutput(@Nonnull Object mixPredicate) {
        IRegistryDelegate effect = (IRegistryDelegate)ReflectionUtil.getPrivateValue(ReflectionUtil.getClass("net.minecraft.potion.PotionBrewing$MixPredicate"), mixPredicate, "field_185200_c");
        return (T)((ForgeRegistryEntry)effect.get());
    }

    @Nullable
    private static <T> T invokeMethod(Class<?> classToSearch, Object instance, String name, Class<?>[] paramTypes, Object ... params) {
        try {
            Method m = METHODS.computeIfAbsent(name, key -> ObfuscationReflectionHelper.findMethod((Class)classToSearch, (String)name, (Class[])paramTypes));
            return (T)(m != null ? m.invoke(instance, params) : null);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException | ObfuscationReflectionHelper.UnableToFindMethodException e) {
            InspirationsRegistry.log.error((Object)e);
            METHODS.putIfAbsent(name, null);
            return null;
        }
    }

    public static Class<? super Object> getClass(String className) {
        return CLASS.computeIfAbsent(className, key -> {
            try {
                return Class.forName(key, false, InspirationsRegistry.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                InspirationsRegistry.log.error((Object)e);
                return null;
            }
        });
    }

    @Nullable
    private static <C, T> T getPrivateValue(Class<? super C> clazz, Object instance, String name) {
        if (clazz == null) {
            return null;
        }
        if (!clazz.isInstance(instance)) {
            return null;
        }
        try {
            Field f = FIELDS.computeIfAbsent(name, key -> ObfuscationReflectionHelper.findField((Class)clazz, (String)name));
            return (T)(f != null ? f.get(instance) : null);
        }
        catch (ClassCastException | IllegalAccessException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            InspirationsRegistry.log.error((Object)e);
            FIELDS.putIfAbsent(name, null);
            return null;
        }
    }
}

