/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.util;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.util.TagUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public final class TextureBlockUtil {
    private static final String TAG_TEXTURE = "texture";
    public static final ModelProperty<String> TEXTURE_PROP = new ModelProperty();

    private TextureBlockUtil() {
    }

    public static void updateTextureBlock(World world, BlockPos pos, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && stack.func_77942_o()) {
            TextureBlockUtil.updateTextureBlock(te, stack.func_77978_p());
        }
    }

    public static void updateTextureBlock(TileEntity te, CompoundNBT tags) {
        String texture;
        if (te != null && !(texture = tags.func_74779_i(TAG_TEXTURE)).isEmpty()) {
            te.getTileData().func_74778_a(TAG_TEXTURE, texture);
        }
    }

    public static ItemStack getPickBlock(IBlockReader world, BlockPos pos, BlockState state) {
        String texture;
        Block block = state.func_177230_c();
        ItemStack stack = new ItemStack((IItemProvider)block);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && !(texture = TextureBlockUtil.getTextureBlockName(te)).isEmpty()) {
            CompoundNBT tags = new CompoundNBT();
            tags.func_74778_a(TAG_TEXTURE, texture);
            stack.func_77982_d(tags);
        }
        return stack;
    }

    public static Block getTextureBlock(TileEntity te) {
        if (te == null) {
            return Blocks.field_150350_a;
        }
        String blockName = TextureBlockUtil.getTextureBlockName(te);
        if (blockName.isEmpty()) {
            return Blocks.field_150350_a;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
    }

    public static String getTextureBlockName(TileEntity te) {
        if (te == null) {
            return "";
        }
        return te.getTileData().func_74779_i(TAG_TEXTURE);
    }

    public static ItemStack createTexturedStack(Block texturable, Block block) {
        ItemStack stack = new ItemStack((IItemProvider)texturable);
        if (block != null && block != Blocks.field_150350_a) {
            TextureBlockUtil.setStackTexture(stack, block.getRegistryName().toString());
        }
        return stack;
    }

    public static ItemStack setStackTexture(ItemStack stack, @Nonnull String blockName) {
        if (!blockName.isEmpty()) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74778_a(TAG_TEXTURE, blockName);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public static ItemStack setStackTexture(ItemStack stack, Block block) {
        if (block == null || block == Blocks.field_150350_a) {
            return stack;
        }
        return TextureBlockUtil.setStackTexture(stack, block.getRegistryName().toString());
    }

    public static void addBlocksFromTag(Block block, Tag<Item> tag, NonNullList<ItemStack> list) {
        boolean added = false;
        for (Item candidate : tag.func_199885_a()) {
            if (!(candidate instanceof BlockItem)) continue;
            Block textureBlock = ((BlockItem)candidate).func_179223_d();
            if (block.getClass().isInstance(textureBlock)) continue;
            added = true;
            list.add((Object)TextureBlockUtil.createTexturedStack(block, textureBlock));
            if (((Boolean)Config.showAllVariants.get()).booleanValue()) continue;
            return;
        }
        if (!added) {
            list.add((Object)new ItemStack((IItemProvider)block));
        }
    }

    public static String getTextureBlockName(ItemStack stack) {
        return TagUtil.getTagSafe(stack).func_74779_i(TAG_TEXTURE);
    }

    public static Block getTextureBlock(ItemStack stack) {
        String texture = TextureBlockUtil.getTextureBlockName(stack);
        if (texture.isEmpty()) {
            return Blocks.field_150350_a;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(texture));
    }
}

