/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei;

import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.TextureRecipe;
import knightminer.inspirations.library.util.TextureBlockUtil;
import knightminer.inspirations.plugins.jei.TextureRecipeExtension;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IRecipeManager recipeManager;
    public static ICraftingGridHelper vanillaCraftingHelper;
    public static IModIdHelper modIdHelper;

    public ResourceLocation getPluginUid() {
        return Util.getResource("jei");
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        ISubtypeInterpreter texture = TextureBlockUtil::getTextureBlockName;
        if (PulseBase.isBuildingLoaded()) {
            registry.registerSubtypeInterpreter(InspirationsBuilding.shelf_normal.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.shelf_ancient.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.shelf_rainbow.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.shelf_tomes.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.whiteEnlightenedBush.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.redEnlightenedBush.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.greenEnlightenedBush.func_199767_j(), texture);
            registry.registerSubtypeInterpreter(InspirationsBuilding.blueEnlightenedBush.func_199767_j(), texture);
        }
    }

    public void registerRecipes(IRecipeRegistration registry) {
        vanillaCraftingHelper = registry.getJeiHelpers().getGuiHelper().createCraftingGridHelper(1);
        modIdHelper = registry.getJeiHelpers().getModIdHelper();
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registry) {
        registry.getCraftingCategory().addCategoryExtension(TextureRecipe.class, TextureRecipeExtension::new);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeManager = jeiRuntime.getRecipeManager();
    }
}

