/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.TextureRecipe;
import knightminer.inspirations.library.util.TextureBlockUtil;
import knightminer.inspirations.plugins.jei.JEIPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.Size2i;

public class TextureRecipeExtension
implements ICraftingCategoryExtension,
ICustomCraftingCategoryExtension {
    private final TextureRecipe recipe;
    private final Size2i size;
    private final List<List<ItemStack>> allOutputs;
    private final List<ItemStack> displayOutputs;

    public TextureRecipeExtension(TextureRecipe recipe) {
        this.recipe = recipe;
        this.size = new Size2i(recipe.getRecipeWidth(), recipe.getRecipeHeight());
        ItemStack output = this.recipe.func_77571_b();
        List displayVariants = Arrays.stream(recipe.texture.func_193365_a()).map(s -> TextureBlockUtil.setStackTexture(output.func_77946_l(), Block.func_149634_a((Item)s.func_77973_b()))).collect(Collectors.toList());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(displayVariants);
        builder.add((Object)output);
        ImmutableList allVariants = builder.build();
        this.allOutputs = ImmutableList.of((Object)allVariants);
        this.displayOutputs = displayVariants.isEmpty() ? allVariants : displayVariants;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.func_199560_c();
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients((List)this.recipe.func_192400_c());
        ingredients.setOutputLists(VanillaTypes.ITEM, this.allOutputs);
    }

    public Size2i getSize() {
        return this.size;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        ImmutableList outputs = this.displayOutputs;
        IFocus ifocus = recipeLayout.getFocus();
        if (ifocus != null && ifocus.getValue() instanceof ItemStack) {
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(VanillaTypes.ITEM);
            ItemStack focus = (ItemStack)ifocus.getValue();
            IFocus.Mode mode = ifocus.getMode();
            if (mode == IFocus.Mode.INPUT && this.recipe.texture.test(focus)) {
                outputs = ImmutableList.of((Object)TextureBlockUtil.setStackTexture(this.recipe.func_77571_b().func_77946_l(), Block.func_149634_a((Item)focus.func_77973_b())));
            } else if (mode == IFocus.Mode.OUTPUT) {
                ItemStack output = focus.func_77946_l();
                output.func_190920_e(this.recipe.func_77571_b().func_190916_E());
                outputs = ImmutableList.of((Object)output);
                Block textureBlock = TextureBlockUtil.getTextureBlock(focus);
                if (textureBlock != Blocks.field_150350_a) {
                    guiIngredients.setOverrideDisplayFocus(JEIPlugin.recipeManager.createFocus(IFocus.Mode.INPUT, (Object)new ItemStack((IItemProvider)textureBlock)));
                }
            }
        }
        JEIPlugin.vanillaCraftingHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.size.width, this.size.height);
        guiItemStacks.set(0, outputs);
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null) {
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    boolean showAdvanced;
                    if (JEIPlugin.modIdHelper.isDisplayingModNameEnabled()) {
                        String recipeModId = registryName.func_110624_b();
                        boolean modIdDifferent = false;
                        ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                        if (itemRegistryName != null) {
                            String itemModId = itemRegistryName.func_110624_b();
                            boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                        }
                        if (modIdDifferent) {
                            String modName = JEIPlugin.modIdHelper.getFormattedModNameForModId(recipeModId);
                            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                        }
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.hasShiftDown();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
    }
}

